/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference;

import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class CseUriTemplateHandler
extends DefaultUriTemplateHandler {
    private Field hostField = ReflectionUtils.findField(UriComponentsBuilder.class, (String)"host");

    public CseUriTemplateHandler() {
        ReflectionUtils.makeAccessible((Field)this.hostField);
        this.setStrictEncoding(true);
    }

    protected URI expandInternal(String uriTemplate, Map<String, ?> uriVariables) {
        UriComponentsBuilder uriComponentsBuilder = this.initUriComponentsBuilder(uriTemplate);
        UriComponents uriComponents = this.expandAndEncode(uriComponentsBuilder, uriVariables);
        return this.createUri(uriTemplate, uriComponentsBuilder, uriComponents);
    }

    protected URI expandInternal(String uriTemplate, Object ... uriVariables) {
        UriComponentsBuilder uriComponentsBuilder = this.initUriComponentsBuilder(uriTemplate);
        UriComponents uriComponents = this.expandAndEncode(uriComponentsBuilder, uriVariables);
        return this.createUri(uriTemplate, uriComponentsBuilder, uriComponents);
    }

    private URI createUri(String uriTemplate, UriComponentsBuilder builder, UriComponents uriComponents) {
        String strUri = uriComponents.toUriString();
        if (this.isCrossApp(uriTemplate, builder)) {
            int idx = strUri.indexOf(47, "cse://".length());
            strUri = strUri.substring(0, idx) + ":" + strUri.substring(idx + 1);
        }
        try {
            return new URI(strUri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not create URI object: " + ex.getMessage(), ex);
        }
    }

    protected boolean isCrossApp(String uriTemplate, UriComponentsBuilder builder) {
        String host = (String)ReflectionUtils.getField((Field)this.hostField, (Object)builder);
        int pos = "cse://".length() + host.length();
        return uriTemplate.charAt(pos) == ':';
    }
}

