/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.base;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.base.DynamicEnum;
import org.apache.servicecomb.foundation.common.base.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicEnumCache<T extends DynamicEnum<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicEnumCache.class);
    private final Class<T> cls;
    private final Map<Object, T> values;
    private final Constructor<T> constructor;

    public DynamicEnumCache(Class<T> cls) {
        try {
            this.cls = cls;
            this.constructor = this.initFactory();
            this.values = this.initValues();
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to init dynamic enum, class=" + cls.getName(), e);
        }
    }

    private Constructor<T> initFactory() throws NoSuchMethodException {
        ParameterizedType superClass = (ParameterizedType)this.cls.getGenericSuperclass();
        Class argument = (Class)superClass.getActualTypeArguments()[0];
        return this.cls.getConstructor(argument);
    }

    private Map<Object, T> initValues() {
        LinkedHashMap values = new LinkedHashMap();
        EnumUtils.findEnumFields(this.cls).map(field -> (DynamicEnum)EnumUtils.readEnum(field)).forEach(oneEnum -> values.put(oneEnum.getValue(), oneEnum));
        return Collections.unmodifiableMap(values);
    }

    public T fromValue(Object value) {
        if (value == null) {
            return null;
        }
        DynamicEnum instance = (DynamicEnum)this.values.get(value);
        try {
            return (T)(instance != null ? instance : (DynamicEnum)this.constructor.newInstance(value));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOGGER.error("failed to create enum, class={}, value={}.", (Object)this.cls.getName(), value);
            return null;
        }
    }
}

