/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.http.client.common.HttpRequest;
import org.apache.servicecomb.http.client.common.HttpResponse;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.service.center.client.AddressManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCenterRawClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCenterRawClient.class);
    private static final String HEADER_TENANT_NAME = "x-domain-name";
    private String tenantName;
    private HttpTransport httpTransport;
    private AddressManager addressManager;

    private ServiceCenterRawClient(String tenantName, HttpTransport httpTransport, AddressManager addressManager) {
        this.httpTransport = httpTransport;
        this.tenantName = tenantName;
        this.addressManager = addressManager;
    }

    public HttpResponse getHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        return this.doHttpRequest(url, headers, content, "GET");
    }

    public HttpResponse postHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        return this.doHttpRequest(url, headers, content, "POST");
    }

    public HttpResponse putHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        return this.doHttpRequest(url, headers, content, "PUT");
    }

    public HttpResponse deleteHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        return this.doHttpRequest(url, headers, content, "DELETE");
    }

    private HttpResponse doHttpRequest(String url, Map<String, String> headers, String content, String method) throws IOException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put(HEADER_TENANT_NAME, this.tenantName);
        HttpRequest httpRequest = new HttpRequest(this.addressManager.address() + url, headers, content, method);
        try {
            return this.httpTransport.doRequest(httpRequest);
        }
        catch (IOException e) {
            LOGGER.warn("send request to {} failed and retry to {} once. ", new Object[]{this.addressManager.address(), this.addressManager.nextAddress(), e});
            httpRequest = new HttpRequest(this.addressManager.address() + url, headers, content, method);
            try {
                return this.httpTransport.doRequest(httpRequest);
            }
            catch (IOException ioException) {
                LOGGER.warn("retry to {} failed again, and change next address {}. ", (Object)this.addressManager.address(), (Object)this.addressManager.nextAddress());
                throw ioException;
            }
        }
    }

    public static class Builder {
        private String tenantName;
        private HttpTransport httpTransport;
        private AddressManager addressManager;

        public Builder setTenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public Builder setAddressManager(AddressManager addressManager) {
            this.addressManager = addressManager;
            return this;
        }

        public ServiceCenterRawClient build() {
            return new ServiceCenterRawClient(this.tenantName, this.httpTransport, this.addressManager);
        }
    }
}

