/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client;

import com.google.common.eventbus.EventBus;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.http.client.task.AbstractTask;
import org.apache.servicecomb.http.client.task.Task;
import org.apache.servicecomb.service.center.client.DiscoveryEvents;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.ServiceCenterRegistration;
import org.apache.servicecomb.service.center.client.model.FindMicroserviceInstancesResponse;
import org.apache.servicecomb.service.center.client.model.Microservice;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCenterDiscovery
extends AbstractTask {
    private static final String ALL_VERSION = "0+";
    private static final long POLL_INTERVAL = 15000L;
    private boolean started = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCenterRegistration.class);
    private final ServiceCenterClient serviceCenterClient;
    private final EventBus eventBus;
    private Microservice myself;
    private final Map<SubscriptionKey, SubscriptionValue> instancesCache = new ConcurrentHashMap<SubscriptionKey, SubscriptionValue>();

    public ServiceCenterDiscovery(ServiceCenterClient serviceCenterClient, EventBus eventBus) {
        super("service-center-discovery-task");
        this.serviceCenterClient = serviceCenterClient;
        this.eventBus = eventBus;
    }

    public void updateMySelf(Microservice myself) {
        this.myself = myself;
    }

    public void startDiscovery() {
        if (!this.started) {
            this.started = true;
            this.startTask(new PullInstanceTask());
        }
    }

    public void register(Microservice microservice) {
        SubscriptionKey subscriptionKey = new SubscriptionKey(microservice.getAppId(), microservice.getServiceName());
        this.instancesCache.computeIfAbsent(subscriptionKey, key -> new SubscriptionValue());
    }

    class PullInstanceTask
    implements Task {
        PullInstanceTask() {
        }

        public void execute() {
            ServiceCenterDiscovery.this.instancesCache.forEach((k, v) -> {
                try {
                    FindMicroserviceInstancesResponse instancesResponse = ServiceCenterDiscovery.this.serviceCenterClient.findMicroserviceInstance(ServiceCenterDiscovery.this.myself.getServiceId(), k.appId, k.serviceName, ServiceCenterDiscovery.ALL_VERSION, v.revision);
                    if (instancesResponse.isModified()) {
                        LOGGER.info("Instance changed event, current: revision={}, instances={}; origin: revision={}, instances={}; appId={}, serviceName={}", new Object[]{instancesResponse.getRevision(), this.instanceToString(instancesResponse.getMicroserviceInstancesResponse().getInstances()), v.revision, this.instanceToString(v.instancesCache), k.appId, k.serviceName});
                        v.instancesCache = instancesResponse.getMicroserviceInstancesResponse().getInstances();
                        v.revision = instancesResponse.getRevision();
                        ServiceCenterDiscovery.this.eventBus.post((Object)new DiscoveryEvents.InstanceChangedEvent(k.appId, k.serviceName, v.instancesCache));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("find service instance failed.", (Throwable)e);
                }
            });
            ServiceCenterDiscovery.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ServiceCenterDiscovery.this, 15000L, (Task)new PullInstanceTask()));
        }

        private String instanceToString(List<MicroserviceInstance> instances) {
            if (instances == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (MicroserviceInstance instance : instances) {
                for (String endpoint : instance.getEndpoints()) {
                    sb.append(endpoint.length() > 64 ? endpoint.substring(0, 64) : endpoint);
                    sb.append("|");
                }
            }
            sb.append("#");
            return sb.toString();
        }
    }

    class SubscriptionValue {
        String revision;
        List<MicroserviceInstance> instancesCache;

        SubscriptionValue() {
        }
    }

    class SubscriptionKey {
        final String appId;
        final String serviceName;

        SubscriptionKey(String appId, String serviceName) {
            this.appId = appId;
            this.serviceName = serviceName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubscriptionKey that = (SubscriptionKey)o;
            return this.appId.equals(that.appId) && this.serviceName.equals(that.serviceName);
        }

        public int hashCode() {
            return Objects.hash(this.appId, this.serviceName);
        }
    }
}

