/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client.http;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.auth.SignRequest;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.apache.servicecomb.serviceregistry.client.http.HttpClientPool;
import org.apache.servicecomb.serviceregistry.client.http.RequestContext;
import org.apache.servicecomb.serviceregistry.client.http.RequestParam;
import org.apache.servicecomb.serviceregistry.client.http.RestResponse;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RestClientUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClientUtil.class);
    static final String HEADER_CONTENT_TYPE = "Content-Type";
    static final String HEADER_USER_AGENT = "User-Agent";
    static final String HEADER_TENANT_NAME = "x-domain-name";
    private List<AuthHeaderProvider> authHeaderProviders;
    private int requestTimeout;
    private String tenantName;
    private HttpClientPool httpClientPool;

    RestClientUtil(ServiceRegistryConfig serviceRegistryConfig) {
        this.authHeaderProviders = serviceRegistryConfig.getAuthHeaderProviders();
        this.requestTimeout = serviceRegistryConfig.getRequestTimeout();
        this.tenantName = serviceRegistryConfig.getTenantName();
        this.httpClientPool = new HttpClientPool(serviceRegistryConfig.getClientName());
    }

    public void httpDo(RequestContext requestContext, Handler<RestResponse> responseHandler) {
        if (requestContext.getParams().getTimeout() != 0L) {
            this.httpDo(requestContext.getParams().getTimeout(), requestContext, responseHandler);
            return;
        }
        this.httpDo(this.requestTimeout, requestContext, responseHandler);
    }

    public void httpDo(long timeout, RequestContext requestContext, Handler<RestResponse> responseHandler) {
        HttpClientWithContext vertxHttpClient = this.httpClientPool.getClient();
        vertxHttpClient.runOnContext(httpClient -> {
            IpPort ipPort = requestContext.getIpPort();
            HttpMethod httpMethod = requestContext.getMethod();
            RequestParam requestParam = requestContext.getParams();
            if (ipPort == null) {
                LOGGER.error("request address is null");
                responseHandler.handle((Object)new RestResponse(requestContext, null));
                return;
            }
            StringBuilder url = new StringBuilder(requestContext.getUri());
            String queryParams = requestParam.getQueryParams();
            if (!queryParams.isEmpty()) {
                url.append(url.lastIndexOf("?") > 0 ? "&" : "?").append(queryParams);
            }
            HttpClientRequest httpClientRequest = httpClient.request(httpMethod, ipPort.getPort(), ipPort.getHostOrIp(), url.toString(), response -> responseHandler.handle((Object)new RestResponse(requestContext, (HttpClientResponse)response)));
            httpClientRequest.setTimeout(timeout).exceptionHandler(e -> {
                LOGGER.error("{} {} fail, endpoint is {}:{}, message: {}", new Object[]{httpMethod, url.toString(), ipPort.getHostOrIp(), ipPort.getPort(), e.getMessage()});
                if (e instanceof UnknownHostException) {
                    LOGGER.error("DNS resolve failed!", e);
                }
                responseHandler.handle((Object)new RestResponse(requestContext, null));
            });
            Map<String, String> headers = this.defaultHeaders();
            httpClientRequest.headers().addAll(headers);
            if (requestParam.getHeaders() != null && requestParam.getHeaders().size() > 0) {
                headers.putAll(requestParam.getHeaders());
                for (Map.Entry<String, String> header : requestParam.getHeaders().entrySet()) {
                    httpClientRequest.putHeader(header.getKey(), header.getValue());
                }
            }
            if (requestParam.getCookies() != null && requestParam.getCookies().size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry<String, String> cookie : requestParam.getCookies().entrySet()) {
                    stringBuilder.append(cookie.getKey()).append("=").append(cookie.getValue()).append("; ");
                }
                httpClientRequest.putHeader("Cookie", stringBuilder.toString());
                headers.put("Cookie", stringBuilder.toString());
            }
            SignRequest signReq = this.createSignRequest(requestContext.getMethod().toString(), requestContext.getIpPort(), requestContext.getParams(), url.toString(), headers);
            httpClientRequest.headers().addAll(this.getSignAuthHeaders(signReq));
            if (httpMethod != HttpMethod.GET && requestParam.getBody() != null && requestParam.getBody().length > 0) {
                httpClientRequest.end(Buffer.buffer((byte[])requestParam.getBody()));
            } else {
                httpClientRequest.end();
            }
        });
    }

    public RequestContext createRequestContext(HttpMethod method, IpPort ipPort, String uri, RequestParam requestParam) {
        RequestContext requestContext = new RequestContext();
        requestContext.setMethod(method);
        requestContext.setIpPort(ipPort);
        requestContext.setUri(uri);
        requestContext.setParams(requestParam);
        return requestContext;
    }

    public SignRequest createSignRequest(String method, IpPort ipPort, RequestParam requestParam, String url, Map<String, String> headers) {
        SignRequest signReq = new SignRequest();
        StringBuilder endpoint = new StringBuilder("https://" + ipPort.getHostOrIp());
        endpoint.append(":" + ipPort.getPort());
        endpoint.append(url);
        try {
            signReq.setEndpoint(new URI(endpoint.toString()));
        }
        catch (URISyntaxException e) {
            LOGGER.error("set uri failed, uri is {}, message: {}", (Object)endpoint.toString(), (Object)e.getMessage());
        }
        signReq.setContent(requestParam.getBody() != null && requestParam.getBody().length > 0 ? new ByteArrayInputStream(requestParam.getBody()) : null);
        signReq.setHeaders(headers);
        signReq.setHttpMethod(method);
        signReq.setQueryParams(requestParam.getQueryParamsMap());
        return signReq;
    }

    public void addDefaultHeaders(HttpClientRequest request) {
        request.headers().addAll(this.getDefaultHeaders());
    }

    private Map<String, String> defaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HEADER_CONTENT_TYPE, "application/json");
        headers.put(HEADER_USER_AGENT, "cse-serviceregistry-client/1.0.0");
        headers.put(HEADER_TENANT_NAME, this.tenantName);
        return headers;
    }

    public MultiMap getDefaultHeaders() {
        return new CaseInsensitiveHeaders().addAll(this.defaultHeaders());
    }

    public void get(IpPort ipPort, String uri, RequestParam requestParam, Handler<RestResponse> responseHandler) {
        this.httpDo(this.createRequestContext(HttpMethod.GET, ipPort, uri, requestParam), responseHandler);
    }

    public void post(IpPort ipPort, String uri, RequestParam requestParam, Handler<RestResponse> responseHandler) {
        this.httpDo(this.createRequestContext(HttpMethod.POST, ipPort, uri, requestParam), responseHandler);
    }

    public void put(IpPort ipPort, String uri, RequestParam requestParam, Handler<RestResponse> responseHandler) {
        this.httpDo(this.createRequestContext(HttpMethod.PUT, ipPort, uri, requestParam), responseHandler);
    }

    public void delete(IpPort ipPort, String uri, RequestParam requestParam, Handler<RestResponse> responseHandler) {
        this.httpDo(this.createRequestContext(HttpMethod.DELETE, ipPort, uri, requestParam), responseHandler);
    }

    public Map<String, String> getSignAuthHeaders(SignRequest signReq) {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.authHeaderProviders.forEach(provider -> headers.putAll(provider.getSignAuthHeaders(signReq)));
        return headers;
    }
}

