/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.auth;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.auth.Cipher;
import org.apache.servicecomb.foundation.auth.DefaultCipher;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.serviceregistry.auth.TokenCacheManager;

public class TokenAuthHeaderProvider
implements AuthHeaderProvider {
    public static final String ACCOUNT_NAME_KEY = "servicecomb.credentials.account.name";
    public static final String PASSWORD_KEY = "servicecomb.credentials.account.password";
    public static final String CIPHER_KEY = "servicecomb.credentials.cipher";
    private String registryName;
    private String accountName;
    private String password;
    private String cipherName;

    public TokenAuthHeaderProvider() {
        this.registryName = "Default";
        this.accountName = DynamicPropertyFactory.getInstance().getStringProperty(ACCOUNT_NAME_KEY, null).get();
        this.password = DynamicPropertyFactory.getInstance().getStringProperty(PASSWORD_KEY, null).get();
        this.cipherName = DynamicPropertyFactory.getInstance().getStringProperty(CIPHER_KEY, "default").get();
        if (StringUtils.isNotEmpty((CharSequence)this.accountName)) {
            TokenCacheManager.getInstance().addTokenCache(this.registryName, this.accountName, this.password, this.getCipher());
        }
    }

    public TokenAuthHeaderProvider(String registryName, String accountName, String password, String cipherName) {
        this.registryName = registryName;
        this.accountName = accountName;
        this.password = password;
        this.cipherName = cipherName;
        TokenCacheManager.getInstance().addTokenCache(this.registryName, this.accountName, this.password, this.getCipher());
    }

    public Map<String, String> authHeaders() {
        String token = TokenCacheManager.getInstance().getToken(this.registryName);
        if (StringUtils.isEmpty((CharSequence)token)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + token);
        return Collections.unmodifiableMap(header);
    }

    private Cipher getCipher() {
        if ("default".equals(this.cipherName)) {
            return DefaultCipher.getInstance();
        }
        Map cipherBeans = BeanUtils.getBeansOfType(Cipher.class);
        return cipherBeans.values().stream().filter(c -> c.name().equals(this.cipherName)).findFirst().orElseThrow(() -> new IllegalArgumentException("failed to find cipher named " + this.cipherName));
    }
}

