/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common.auth;

import java.util.Map;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.HttpRequest;
import org.apache.servicecomb.http.client.common.auth.AKSKHeaderExtensionUtil;

public class AKSKHeaderUtil {
    public static final String X_SERVICE_AK = "X-Service-AK";
    public static final String X_SERVICE_SHAAKSK = "X-Service-ShaAKSK";
    public static final String X_SERVICE_PROJECT = "X-Service-Project";

    public static void addAKSKHeader(HttpRequest httpRequest, HttpConfiguration.AKSKProperties serviceCombAkSkProperties) {
        if (serviceCombAkSkProperties.isEnabled()) {
            httpRequest.addHeader(X_SERVICE_AK, serviceCombAkSkProperties.getAccessKey());
            httpRequest.addHeader(X_SERVICE_SHAAKSK, serviceCombAkSkProperties.getSecretKey());
            httpRequest.addHeader(X_SERVICE_PROJECT, serviceCombAkSkProperties.getProject());
            return;
        }
        Map<String, String> headerMap = AKSKHeaderExtensionUtil.genAuthHeaders();
        if (!headerMap.isEmpty()) {
            httpRequest.addHeader(X_SERVICE_AK, headerMap.get(X_SERVICE_AK));
            httpRequest.addHeader(X_SERVICE_SHAAKSK, headerMap.get(X_SERVICE_SHAAKSK));
            httpRequest.addHeader(X_SERVICE_PROJECT, headerMap.get(X_SERVICE_PROJECT));
        }
    }
}

