/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.kie.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.kie.client.http.HttpRequest;
import org.apache.servicecomb.kie.client.http.HttpResponse;
import org.apache.servicecomb.kie.client.http.HttpTransport;
import org.apache.servicecomb.kie.client.http.HttpTransportFactory;

public class KieRawClient {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 30110;
    private static final String PROJECT_NAME = "default";
    private static final String V4_PREFIX = "v1";
    private String basePath;
    private String host;
    private int port;
    private String projectName;
    private HttpTransport httpTransport;

    public KieRawClient() {
        this(DEFAULT_HOST, 30110, PROJECT_NAME, HttpTransportFactory.getDefaultHttpTransport());
    }

    private KieRawClient(String host, int port, String projectName, HttpTransport httpTransport) {
        this.host = host;
        this.port = port;
        this.projectName = projectName;
        this.httpTransport = httpTransport;
        String hostLowercase = host.toLowerCase();
        if (!hostLowercase.startsWith("https://") && !hostLowercase.startsWith("http://")) {
            host = "http://" + host;
        }
        this.basePath = host + ":" + port + "/" + V4_PREFIX + "/" + projectName;
    }

    public HttpResponse getHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        HttpRequest httpRequest = new HttpRequest(this.basePath + url, headers, content);
        return this.httpTransport.get(httpRequest);
    }

    public HttpResponse postHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        HttpRequest httpRequest = new HttpRequest(this.basePath + url, headers, content);
        return this.httpTransport.post(httpRequest);
    }

    public HttpResponse putHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        HttpRequest httpRequest = new HttpRequest(this.basePath + url, headers, content);
        return this.httpTransport.put(httpRequest);
    }

    public HttpResponse deleteHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        HttpRequest httpRequest = new HttpRequest(this.basePath + url, headers, content);
        return this.httpTransport.delete(httpRequest);
    }

    public HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    public void setHttpTransport(HttpTransport httpTransport) {
        this.httpTransport = httpTransport;
    }

    public static class Builder {
        private String host = "localhost";
        private int port = 30110;
        private String projectName = "default";
        private HttpTransport httpTransport;

        public String getProjectName() {
            return this.projectName;
        }

        public Builder setProjectName(String projectName) {
            if (projectName == null) {
                projectName = KieRawClient.PROJECT_NAME;
            }
            this.projectName = projectName;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Builder setPort(int port) {
            if (port <= 0) {
                port = 30110;
            }
            this.port = port;
            return this;
        }

        public String getHost() {
            return this.host;
        }

        public Builder setHost(String host) {
            if (host == null) {
                host = KieRawClient.DEFAULT_HOST;
            }
            this.host = host;
            return this;
        }

        public HttpTransport getHttpTransport() {
            return this.httpTransport;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public KieRawClient build() {
            return new KieRawClient(this.host, this.port, this.projectName, this.httpTransport);
        }
    }
}

