/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.kie.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.kie.client.KieRawClient;
import org.apache.servicecomb.kie.client.http.HttpResponse;
import org.apache.servicecomb.kie.client.model.KVBody;
import org.apache.servicecomb.kie.client.model.KVDoc;
import org.apache.servicecomb.kie.client.model.KVResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieClient.class);
    private KieRawClient httpClient;

    public KieClient() {
        this(new KieRawClient());
    }

    public KieClient(String host, int port, String projectName) {
        this.httpClient = new KieRawClient.Builder().setHost(host).setPort(port).setProjectName(projectName).build();
    }

    public KieClient(KieRawClient serviceCenterRawClient) {
        this.httpClient = serviceCenterRawClient;
    }

    public String putKeyValue(String key, KVBody kvBody) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            HttpResponse response = this.httpClient.putHttpRequest("/kie/kv/" + key, null, mapper.writeValueAsString((Object)kvBody));
            if (response.getStatusCode() == 200) {
                return response.getContent();
            }
            LOGGER.error("create keyValue fails, responseStatusCode={}, responseMessage={}, responseContent{}", new Object[]{response.getStatusCode(), response.getMessage(), response.getContent()});
        }
        catch (IOException e) {
            LOGGER.error("create keyValue fails", (Throwable)e);
        }
        return null;
    }

    public List<KVResponse> getValueOfKey(String key) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/kie/kv/" + key, null, null);
            if (response.getStatusCode() == 200) {
                ObjectMapper mapper = new ObjectMapper();
                return (List)mapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<KVResponse>>(){});
            }
            LOGGER.error("get value of key fails, responseStatusCode={}, responseMessage={}, responseContent{}", new Object[]{response.getStatusCode(), response.getMessage(), response.getContent()});
        }
        catch (IOException e) {
            LOGGER.error("get value of key fails", (Throwable)e);
        }
        return null;
    }

    public List<KVResponse> searchKeyValueByLabels(Map<String, String> labels) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : labels.entrySet()) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append(":");
                stringBuilder.append(entry.getValue());
                stringBuilder.append("+");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            HttpResponse response = this.httpClient.getHttpRequest("/kie/kv?q=" + stringBuilder.toString(), null, null);
            if (response.getStatusCode() == 200) {
                ObjectMapper mapper = new ObjectMapper();
                return (List)mapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<KVResponse>>(){});
            }
            LOGGER.error("search keyValue by labels fails, responseStatusCode={}, responseMessage={}, responseContent{}", new Object[]{response.getStatusCode(), response.getMessage(), response.getContent()});
        }
        catch (IOException e) {
            LOGGER.error("search keyValue by labels fails", (Throwable)e);
        }
        return null;
    }

    public void deleteKeyValue(KVDoc kvDoc) {
        try {
            HttpResponse response = this.httpClient.deleteHttpRequest("/kie/kv/?kvID=" + kvDoc.getId(), null, null);
            if (response.getStatusCode() == 204) {
                LOGGER.info("Delete keyValue success");
            } else {
                LOGGER.error("delete keyValue fails, responseStatusCode={}, responseMessage={}, responseContent{}", new Object[]{response.getStatusCode(), response.getMessage(), response.getContent()});
            }
        }
        catch (IOException e) {
            LOGGER.error("delete keyValue fails", (Throwable)e);
        }
    }
}

