/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.nacos.archaius.sources;

import com.google.common.collect.ImmutableMap;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.ConfigMapping;
import org.apache.servicecomb.config.nacos.client.ConfigurationAction;
import org.apache.servicecomb.config.nacos.client.NacosClient;
import org.apache.servicecomb.config.nacos.client.NacosConfig;
import org.apache.servicecomb.config.spi.ConfigCenterConfigurationSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfigurationSourceImpl
implements ConfigCenterConfigurationSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCenterConfigurationSource.class);
    private final Map<String, Object> valueCache = new ConcurrentHashMap<String, Object>();
    private List<WatchedUpdateListener> listeners = new CopyOnWriteArrayList<WatchedUpdateListener>();
    private final UpdateHandler updateHandler = new UpdateHandler();

    public boolean isValidSource(Configuration localConfiguration) {
        if (localConfiguration.getProperty("servicecomb.nacos.serverAddr") == null) {
            LOGGER.warn("Nacos configuration source is not configured!");
            return false;
        }
        return true;
    }

    public void init(Configuration localConfiguration) {
        NacosConfig.setConcurrentCompositeConfiguration(localConfiguration);
        this.init();
    }

    private void init() {
        NacosClient nacosClient = new NacosClient(this.updateHandler);
        nacosClient.refreshNacosConfig();
    }

    public void addUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        this.listeners.add(watchedUpdateListener);
    }

    public void removeUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        this.listeners.remove(watchedUpdateListener);
    }

    private void updateConfiguration(WatchedUpdateResult result) {
        for (WatchedUpdateListener l : this.listeners) {
            try {
                l.updateConfiguration(result);
            }
            catch (Throwable ex) {
                LOGGER.error("Error in invoking WatchedUpdateListener", ex);
            }
        }
    }

    public Map<String, Object> getCurrentData() throws Exception {
        return this.valueCache;
    }

    public List<WatchedUpdateListener> getCurrentListeners() {
        return this.listeners;
    }

    public class UpdateHandler {
        public void handle(ConfigurationAction action, Map<String, Object> config) {
            if (config == null || config.isEmpty()) {
                return;
            }
            Map configuration = ConfigMapping.getConvertedMap(config);
            if (ConfigurationAction.CREATE.equals((Object)action)) {
                NacosConfigurationSourceImpl.this.valueCache.putAll(configuration);
                NacosConfigurationSourceImpl.this.updateConfiguration(WatchedUpdateResult.createIncremental((Map)ImmutableMap.copyOf((Map)configuration), null, null));
            } else if (ConfigurationAction.SET.equals((Object)action)) {
                NacosConfigurationSourceImpl.this.valueCache.putAll(configuration);
                NacosConfigurationSourceImpl.this.updateConfiguration(WatchedUpdateResult.createIncremental(null, (Map)ImmutableMap.copyOf((Map)configuration), null));
            } else if (ConfigurationAction.DELETE.equals((Object)action)) {
                configuration.keySet().forEach(NacosConfigurationSourceImpl.this.valueCache::remove);
                NacosConfigurationSourceImpl.this.updateConfiguration(WatchedUpdateResult.createIncremental(null, null, (Map)ImmutableMap.copyOf((Map)configuration)));
            } else {
                LOGGER.error("action: {} is invalid.", (Object)action.name());
                return;
            }
            LOGGER.warn("Config value cache changed: action:{}; item:{}", (Object)action.name(), configuration.keySet());
        }
    }
}

