/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.invocation.endpoint;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.exception.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndpointUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointUtils.class);
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String H2C = "h2c";
    private static final String H2 = "h2";
    private static final String HTTP2 = "http2";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final Map<String, SchemeMeta> SCHEME_META_MAP = ImmutableMap.of((Object)"http", (Object)new SchemeMeta(null, false, 80), (Object)"https", (Object)new SchemeMeta(null, true, 443), (Object)"h2c", (Object)new SchemeMeta("http2", false, 80), (Object)"h2", (Object)new SchemeMeta("http2", true, 443));

    private EndpointUtils() {
    }

    public static Endpoint parse(String uriEndpoint) {
        URI uri = URI.create(uriEndpoint);
        Transport transport = SCBEngine.getInstance().getTransportManager().findTransport(uri.getScheme());
        if (transport == null) {
            LOGGER.error("not deployed transport, uri={}.", (Object)uriEndpoint);
            throw Exceptions.genericConsumer("the endpoint's trnasport is not found.");
        }
        return new Endpoint(transport, uriEndpoint);
    }

    public static String formatFromUri(String inputUri) {
        try {
            return EndpointUtils.doFormatFromUri(inputUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("failed to convert uri to endpoint.", e);
        }
    }

    private static String doFormatFromUri(String inputUri) throws URISyntaxException {
        SchemeMeta schemeMeta;
        URIBuilder builder = new URIBuilder(inputUri);
        if (builder.getScheme() == null) {
            builder.setScheme(H2C);
            builder.setHost(builder.getPath());
            builder.setPath(null);
        }
        if ((schemeMeta = SCHEME_META_MAP.get(builder.getScheme())) == null) {
            return inputUri;
        }
        return EndpointUtils.format(builder, schemeMeta);
    }

    private static String format(URIBuilder builder, SchemeMeta schemeMeta) throws URISyntaxException {
        if (schemeMeta.ssl) {
            builder.addParameter("sslEnabled", "true");
        }
        if (schemeMeta.protocol != null) {
            builder.addParameter("protocol", schemeMeta.protocol);
        }
        if (builder.getPort() == -1) {
            builder.setPort(schemeMeta.defaultPort);
        }
        return builder.setScheme("rest").build().toString();
    }

    private static class SchemeMeta {
        String protocol;
        boolean ssl;
        int defaultPort;

        public SchemeMeta(String protocol, boolean ssl, int defaultPort) {
            this.protocol = protocol;
            this.ssl = ssl;
            this.defaultPort = defaultPort;
        }
    }
}

