/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client.http;

import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.servicecomb.service.center.client.http.HttpRequest;
import org.apache.servicecomb.service.center.client.http.HttpResponse;
import org.apache.servicecomb.service.center.client.http.HttpTransport;

public class HttpTransportImpl
implements HttpTransport {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_USER_AGENT = "User-Agent";
    protected HttpClient httpClient = HttpClients.createDefault();
    private Map<String, String> globalHeaders;

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public HttpResponse get(HttpRequest request) throws IOException {
        request.setMethod("GET");
        return this.doRequest(request);
    }

    @Override
    public HttpResponse post(HttpRequest request) throws IOException {
        request.setMethod("POST");
        return this.doRequest(request);
    }

    @Override
    public HttpResponse put(HttpRequest request) throws IOException {
        request.setMethod("PUT");
        return this.doRequest(request);
    }

    @Override
    public HttpResponse delete(HttpRequest request) throws IOException {
        request.setMethod("DELETE");
        return this.doRequest(request);
    }

    @Override
    public HttpResponse doRequest(HttpRequest httpRequest) throws IOException {
        httpRequest.addHeader(HEADER_CONTENT_TYPE, "application/json");
        httpRequest.addHeader(HEADER_USER_AGENT, "cse-serviceregistry-client/1.0.0");
        if (this.globalHeaders != null) {
            this.globalHeaders.forEach(httpRequest::addHeader);
        }
        org.apache.http.HttpResponse response = this.httpClient.execute(httpRequest.getRealRequest());
        int statusCode = response.getStatusLine().getStatusCode();
        String messgae = response.getStatusLine().getReasonPhrase();
        String context = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        return new HttpResponse(statusCode, messgae, context);
    }

    @Override
    public void addHeaders(Map<String, String> headers) {
        this.globalHeaders = headers;
    }
}

