/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig.client;

import io.vertx.core.json.Json;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.zeroconfig.ZeroConfigRegistryConstants;
import org.apache.servicecomb.zeroconfig.server.ServerMicroserviceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientUtil.class);
    public static final ClientUtil INSTANCE = new ClientUtil();
    private ServerMicroserviceInstance serviceInstanceForHeartbeat;
    private MulticastSocket multicastSocket;
    private InetAddress group;

    public ServerMicroserviceInstance getServiceInstanceForHeartbeat() {
        return this.serviceInstanceForHeartbeat;
    }

    public void setServiceInstanceForHeartbeat(ServerMicroserviceInstance serviceInstanceForHeartbeat) {
        this.serviceInstanceForHeartbeat = serviceInstanceForHeartbeat;
    }

    private ClientUtil() {
    }

    public synchronized void init() {
        try {
            this.group = InetAddress.getByName("225.0.0.0");
            this.multicastSocket = new MulticastSocket();
            this.multicastSocket.setLoopbackMode(false);
            this.multicastSocket.setTimeToLive(ZeroConfigRegistryConstants.TIME_TO_LIVE);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create MulticastSocket object", (Throwable)e);
        }
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this::runHeartbeatTask, 2L, 3L, TimeUnit.SECONDS);
    }

    private void runHeartbeatTask() {
        if (this.serviceInstanceForHeartbeat != null) {
            try {
                byte[] heartbeatEventDataBytes = Json.encode((Object)this.serviceInstanceForHeartbeat).getBytes();
                DatagramPacket instanceDataPacket = new DatagramPacket(heartbeatEventDataBytes, heartbeatEventDataBytes.length, this.group, ZeroConfigRegistryConstants.PORT);
                this.multicastSocket.send(instanceDataPacket);
            }
            catch (Exception e) {
                LOGGER.error("Failed to send heartbeat event for object: {}", (Object)this.serviceInstanceForHeartbeat.toString(), (Object)e);
            }
        }
    }

    public static ServerMicroserviceInstance convertToRegisterDataModel(MicroserviceInstance microserviceInstance, Microservice microservice) {
        ServerMicroserviceInstance instance = new ServerMicroserviceInstance();
        instance.setEvent("register");
        instance.setVersion(microservice.getVersion());
        instance.setServiceId(microservice.getServiceId());
        instance.setInstanceId(microserviceInstance.getInstanceId());
        instance.setStatus(microserviceInstance.getStatus().toString());
        instance.setAppId(microservice.getAppId());
        instance.setServiceName(microservice.getServiceName());
        instance.setHostName(microserviceInstance.getHostName());
        instance.setEndpoints(microserviceInstance.getEndpoints());
        instance.setSchemas(microservice.getSchemas());
        return instance;
    }

    public static MicroserviceInstance convertToClientMicroserviceInstance(ServerMicroserviceInstance serverMicroserviceInstance) {
        MicroserviceInstance microserviceInstance = new MicroserviceInstance();
        microserviceInstance.setServiceId(serverMicroserviceInstance.getServiceId());
        microserviceInstance.setInstanceId(serverMicroserviceInstance.getInstanceId());
        microserviceInstance.setHostName(serverMicroserviceInstance.getHostName());
        microserviceInstance.setEndpoints(serverMicroserviceInstance.getEndpoints());
        microserviceInstance.setStatus(MicroserviceInstanceStatus.valueOf((String)serverMicroserviceInstance.getStatus()));
        return microserviceInstance;
    }

    public static Microservice convertToClientMicroservice(ServerMicroserviceInstance serverMicroserviceInstance) {
        Microservice microservice = new Microservice();
        microservice.setAppId(serverMicroserviceInstance.getAppId());
        microservice.setServiceId(serverMicroserviceInstance.getServiceId());
        microservice.setServiceName(serverMicroserviceInstance.getServiceName());
        microservice.setVersion(serverMicroserviceInstance.getVersion());
        microservice.setStatus(serverMicroserviceInstance.getStatus());
        microservice.setSchemas(serverMicroserviceInstance.getSchemas());
        return microservice;
    }

    public static String generateServiceId(Microservice microservice) {
        String serviceIdStringIndex = String.join((CharSequence)"/", microservice.getAppId(), microservice.getServiceName(), microservice.getVersion());
        return UUID.nameUUIDFromBytes(serviceIdStringIndex.getBytes()).toString().split("-")[0];
    }

    public static String generateServiceInstanceId() {
        return UUID.randomUUID().toString().split("-")[0];
    }
}

