/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.deployment;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.deployment.DeploymentProvider;
import org.apache.servicecomb.deployment.SystemBootstrapInfo;

public class DefaultDeploymentProvider
implements DeploymentProvider {
    private static AbstractConfiguration configuration = ConfigUtil.createLocalConfig();

    @Override
    public SystemBootstrapInfo getSystemBootStrapInfo(String systemKey) {
        switch (systemKey) {
            case "ServiceCenter": {
                SystemBootstrapInfo sc = new SystemBootstrapInfo();
                String[] urls = configuration.getStringArray("servicecomb.service.registry.address");
                if (urls == null || urls.length == 0) {
                    urls = new String[]{"http://127.0.0.1:30100"};
                }
                sc.setAccessURL(Arrays.asList(urls));
                return sc;
            }
            case "ConfigCenter": {
                String[] ccAddresses = configuration.getStringArray("servicecomb.config.client.serverUri");
                if (ccAddresses == null || ccAddresses.length == 0) {
                    return null;
                }
                SystemBootstrapInfo cc = new SystemBootstrapInfo();
                cc.setAccessURL(Arrays.asList(ccAddresses));
                return cc;
            }
        }
        return null;
    }

    @VisibleForTesting
    public static void setConfiguration(AbstractConfiguration configuration) {
        DefaultDeploymentProvider.configuration = configuration;
    }
}

