/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.OutputEx;
import io.protostuff.SchemaEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.Message;
import io.protostuff.runtime.FieldMapEx;
import io.protostuff.runtime.FieldSchema;
import io.protostuff.runtime.RuntimeEnv;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import org.apache.servicecomb.foundation.protobuf.ProtoMapper;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoConst;
import org.apache.servicecomb.foundation.protobuf.internal.bean.BeanDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.DeserializerSchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReadSchema<T>
implements SchemaEx<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageReadSchema.class);
    protected ProtoMapper protoMapper;
    protected Message message;
    private FieldMapEx<T> fieldMap;
    private RuntimeEnv.Instantiator<T> instantiator;
    private JavaType javaType;
    Map<String, Type> argumentsTypes;
    private boolean argumentsRoot = false;

    public MessageReadSchema(ProtoMapper protoMapper, Message message, Map<String, Type> argumentsTypes) {
        this.argumentsRoot = true;
        this.protoMapper = protoMapper;
        this.message = message;
        this.argumentsTypes = argumentsTypes;
        this.instantiator = RuntimeEnv.newInstantiator((Class)ProtoConst.MAP_TYPE.getRawClass());
    }

    public MessageReadSchema(ProtoMapper protoMapper, Message message, JavaType javaType) {
        this.protoMapper = protoMapper;
        this.message = message;
        this.javaType = javaType;
        if (javaType.isJavaLangObject() || Map.class.isAssignableFrom(javaType.getRawClass())) {
            javaType = ProtoConst.MAP_TYPE;
        }
        this.instantiator = RuntimeEnv.newInstantiator((Class)javaType.getRawClass());
    }

    public Message getMessage() {
        return this.message;
    }

    @Override
    public T newMessage() {
        return (T)this.instantiator.newInstance();
    }

    @Override
    public String messageName() {
        return this.message.getName();
    }

    public FieldMapEx<T> getFieldMap() {
        return this.fieldMap;
    }

    @Override
    public void init() {
        if (this.argumentsRoot) {
            this.fieldMap = this.protoMapper.getDeserializerSchemaManager().createMapFields(this.message, this.argumentsTypes);
            return;
        }
        if (Map.class.isAssignableFrom(this.javaType.getRawClass())) {
            this.fieldMap = this.protoMapper.getDeserializerSchemaManager().createMapFields(this.message);
            return;
        }
        this.createFieldMap();
    }

    private void createFieldMap() {
        DeserializerSchemaManager deserializerSchemaManager = this.protoMapper.getDeserializerSchemaManager();
        BeanDescriptor beanDescriptor = this.protoMapper.getBeanDescriptorManager().getOrCreateBeanDescriptor((Type)this.javaType);
        ArrayList fieldSchemas = new ArrayList();
        for (PropertyDescriptor propertyDescriptor : beanDescriptor.getPropertyDescriptors().values()) {
            Field protoField = this.message.getField(propertyDescriptor.getName());
            if (protoField == null) {
                LOGGER.info("java field {}:{} not exist in proto message {}, ignore it.", new Object[]{beanDescriptor.getJavaType().getRawClass().getName(), propertyDescriptor.getName(), this.message.getCanonicalName()});
                continue;
            }
            if (propertyDescriptor.getSetter() == null) {
                LOGGER.info("no setter for java field {}:{} in proto message {}, ignore it.", new Object[]{beanDescriptor.getJavaType().getRawClass().getName(), propertyDescriptor.getName(), this.message.getCanonicalName()});
                continue;
            }
            FieldSchema fieldSchema = deserializerSchemaManager.createSchemaField(protoField, propertyDescriptor);
            fieldSchemas.add(fieldSchema);
        }
        this.fieldMap = FieldMapEx.createFieldMap(fieldSchemas);
    }

    @Override
    public void mergeFrom(InputEx input, T message) throws IOException {
        FieldSchema<T> fieldSchema = null;
        try {
            int n = input.readFieldNumber();
            while (n != 0) {
                fieldSchema = this.fieldMap.getFieldByNumber(n);
                if (fieldSchema != null) {
                    n = fieldSchema.mergeFrom(input, message);
                    continue;
                }
                input.handleUnknownField(n);
                n = input.readFieldNumber();
            }
        }
        catch (Throwable e) {
            Field protoField = fieldSchema.getProtoField();
            LOGGER.error("Failed to mergeFrom, field={}:{}, type={}", new Object[]{protoField.getType().getCanonicalName(), protoField.getName(), protoField.getTypeName(), e.getMessage()});
            throw e;
        }
    }

    @Override
    public void writeTo(OutputEx output, Object value) throws IOException {
        throw new UnsupportedOperationException();
    }
}

