/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import com.netflix.config.AbstractPollingScheduler;
import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicConfiguration;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicWatchedConfiguration;
import com.netflix.config.PolledConfigurationSource;
import com.netflix.config.WatchedConfigurationSource;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.servicecomb.config.ConfigMapping;
import org.apache.servicecomb.config.archaius.scheduler.NeverStartPollingScheduler;
import org.apache.servicecomb.config.archaius.sources.ConfigModel;
import org.apache.servicecomb.config.archaius.sources.MicroserviceConfigLoader;
import org.apache.servicecomb.config.archaius.sources.MicroserviceConfigurationSource;
import org.apache.servicecomb.config.spi.ConfigCenterConfigurationSource;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtil.class);
    private static final String MICROSERVICE_CONFIG_LOADER_KEY = "cse-microservice-config-loader";
    private static final String IS_PRINT_URL = "servicecomb.config.log.verbose";
    private static Map<String, Object> localConfig = new HashMap<String, Object>();
    private static final Map<String, Map<String, Object>> EXTRA_CONFIG_MAP = new LinkedHashMap<String, Map<String, Object>>();

    private ConfigUtil() {
    }

    public static void setConfigs(Map<String, Object> config) {
        localConfig = config;
    }

    public static void addConfig(String key, Object value) {
        localConfig.put(key, value);
    }

    public static Object getProperty(String key) {
        Object config = DynamicPropertyFactory.getBackingConfigurationSource();
        return ConfigUtil.getProperty(config, key);
    }

    public static Object getProperty(Object config, String key) {
        if (null != config && Configuration.class.isInstance(config)) {
            Configuration configuration = (Configuration)config;
            return configuration.getProperty(key);
        }
        return null;
    }

    public static List<String> getStringList(@Nonnull Configuration config, @Nonnull String key) {
        return config.getList(key).stream().map(v -> Objects.toString(v, null)).collect(Collectors.toList());
    }

    private static void setMicroserviceConfigLoader(Configuration config, MicroserviceConfigLoader loader) {
        config.setProperty(MICROSERVICE_CONFIG_LOADER_KEY, (Object)loader);
    }

    public static MicroserviceConfigLoader getMicroserviceConfigLoader() {
        return (MicroserviceConfigLoader)ConfigUtil.getProperty(MICROSERVICE_CONFIG_LOADER_KEY);
    }

    public static MicroserviceConfigLoader getMicroserviceConfigLoader(Configuration config) {
        return (MicroserviceConfigLoader)ConfigUtil.getProperty(config, MICROSERVICE_CONFIG_LOADER_KEY);
    }

    public static ConcurrentCompositeConfiguration createLocalConfig() {
        MicroserviceConfigLoader loader = new MicroserviceConfigLoader();
        loader.loadAndSort();
        if (localConfig.size() > 0) {
            ConfigModel model = new ConfigModel();
            model.setConfig(localConfig);
            loader.getConfigModels().add(model);
        }
        LOGGER.info("create local config:");
        boolean isPrintUrl = DynamicPropertyFactory.getInstance().getBooleanProperty(IS_PRINT_URL, true).get();
        if (isPrintUrl) {
            LOGGER.info(" {}.", (Object)StringUtils.join(loader.getConfigModels(), (String)","));
        }
        ConcurrentCompositeConfiguration config = ConfigUtil.createLocalConfig(loader.getConfigModels());
        ConfigUtil.setMicroserviceConfigLoader((Configuration)config, loader);
        return config;
    }

    public static ConcurrentCompositeConfiguration createLocalConfig(List<ConfigModel> configModelList) {
        ConcurrentCompositeConfiguration config = new ConcurrentCompositeConfiguration();
        ConfigUtil.duplicateCseConfigToServicecomb(config, (AbstractConfiguration)new ConcurrentMapConfiguration((Configuration)new SystemConfiguration()), "configFromSystem");
        ConfigUtil.duplicateCseConfigToServicecomb(config, ConfigUtil.convertEnvVariable((AbstractConfiguration)new ConcurrentMapConfiguration((Configuration)new EnvironmentConfiguration())), "configFromEnvironment");
        EXTRA_CONFIG_MAP.entrySet().stream().filter(mapEntry -> !((Map)mapEntry.getValue()).isEmpty()).forEachOrdered(configMapEntry -> ConfigUtil.duplicateCseConfigToServicecomb(config, (AbstractConfiguration)new ConcurrentMapConfiguration((Map)configMapEntry.getValue()), (String)configMapEntry.getKey()));
        config.addConfiguration((AbstractConfiguration)new DynamicConfiguration((PolledConfigurationSource)new MicroserviceConfigurationSource(configModelList), (AbstractPollingScheduler)new NeverStartPollingScheduler()), "configFromYamlFile");
        ConfigUtil.duplicateCseConfigToServicecombAtFront(config, (AbstractConfiguration)new ConcurrentMapConfiguration(ConfigMapping.getConvertedMap((Configuration)config)), "configFromMapping");
        return config;
    }

    public static AbstractConfiguration convertEnvVariable(AbstractConfiguration source) {
        Iterator keys = source.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            CharSequence[] separatedKey = key.split("_");
            if (separatedKey.length == 1) continue;
            String newKey = String.join((CharSequence)".", separatedKey);
            source.addProperty(newKey, source.getProperty(key));
        }
        return source;
    }

    private static void duplicateCseConfigToServicecomb(AbstractConfiguration source) {
        Iterator keys = source.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith("cse.")) continue;
            String servicecombKey = "servicecomb." + key.substring(key.indexOf(".") + 1);
            if (!source.containsKey(servicecombKey)) {
                source.addProperty(servicecombKey, source.getProperty(key));
                continue;
            }
            LOGGER.warn("Key {} with an ambiguous item {} exists, it's recommended to use only one of them.", (Object)key, (Object)servicecombKey);
        }
    }

    private static void duplicateCseConfigToServicecomb(ConcurrentCompositeConfiguration compositeConfiguration, AbstractConfiguration source, String sourceName) {
        ConfigUtil.duplicateCseConfigToServicecomb(source);
        compositeConfiguration.addConfiguration(source, sourceName);
    }

    private static void duplicateCseConfigToServicecombAtFront(ConcurrentCompositeConfiguration compositeConfiguration, AbstractConfiguration source, String sourceName) {
        ConfigUtil.duplicateCseConfigToServicecomb(source);
        compositeConfiguration.addConfigurationAtFront(source, sourceName);
    }

    private static ConfigCenterConfigurationSource createConfigCenterConfigurationSource(Configuration localConfiguration) {
        ConfigCenterConfigurationSource configCenterConfigurationSource = (ConfigCenterConfigurationSource)SPIServiceUtils.getTargetService(ConfigCenterConfigurationSource.class);
        if (null == configCenterConfigurationSource) {
            LOGGER.info("config center SPI service can not find, skip to load configuration from config center");
            return null;
        }
        if (!configCenterConfigurationSource.isValidSource(localConfiguration)) {
            LOGGER.warn("Config Source serverUri is not correctly configured.");
            return null;
        }
        return configCenterConfigurationSource;
    }

    private static void createDynamicWatchedConfiguration(ConcurrentCompositeConfiguration localConfiguration, ConfigCenterConfigurationSource configCenterConfigurationSource) {
        ConcurrentMapConfiguration injectConfig = new ConcurrentMapConfiguration();
        localConfiguration.addConfigurationAtFront((AbstractConfiguration)injectConfig, "extraInjectConfig");
        configCenterConfigurationSource.addUpdateListener(new ServiceCombPropertyUpdateListener(injectConfig));
        DynamicWatchedConfiguration configFromConfigCenter = new DynamicWatchedConfiguration((WatchedConfigurationSource)configCenterConfigurationSource);
        ConfigUtil.duplicateCseConfigToServicecomb((AbstractConfiguration)configFromConfigCenter);
        localConfiguration.addConfigurationAtFront((AbstractConfiguration)configFromConfigCenter, "configCenterConfig");
    }

    public static AbstractConfiguration createDynamicConfig() {
        ConcurrentCompositeConfiguration compositeConfig = ConfigUtil.createLocalConfig();
        ConfigCenterConfigurationSource configCenterConfigurationSource = ConfigUtil.createConfigCenterConfigurationSource((Configuration)compositeConfig);
        if (configCenterConfigurationSource != null) {
            ConfigUtil.createDynamicWatchedConfiguration(compositeConfig, configCenterConfigurationSource);
        }
        return compositeConfig;
    }

    public static void installDynamicConfig() {
        if (ConfigurationManager.isConfigurationInstalled()) {
            LOGGER.warn("Configuration installed by others, will ignore this configuration.");
            return;
        }
        ConcurrentCompositeConfiguration compositeConfig = ConfigUtil.createLocalConfig();
        ConfigCenterConfigurationSource configCenterConfigurationSource = ConfigUtil.createConfigCenterConfigurationSource((Configuration)compositeConfig);
        if (configCenterConfigurationSource != null) {
            ConfigUtil.createDynamicWatchedConfiguration(compositeConfig, configCenterConfigurationSource);
        }
        ConfigurationManager.install((AbstractConfiguration)compositeConfig);
        if (configCenterConfigurationSource != null) {
            configCenterConfigurationSource.init((Configuration)compositeConfig);
        }
    }

    public static void destroyConfigCenterConfigurationSource() {
        SPIServiceUtils.getAllService(ConfigCenterConfigurationSource.class).forEach(source -> {
            try {
                source.destroy();
            }
            catch (Throwable e) {
                LOGGER.error("Failed to destroy {}", (Object)source.getClass().getName());
            }
        });
    }

    public static void addExtraConfig(String extraConfigName, Map<String, Object> extraConfig) {
        EXTRA_CONFIG_MAP.put(extraConfigName, extraConfig);
    }

    public static void clearExtraConfig() {
        EXTRA_CONFIG_MAP.clear();
    }

    public static ConcurrentHashMap<String, DynamicProperty> getAllDynamicProperties() {
        try {
            return (ConcurrentHashMap)FieldUtils.readDeclaredStaticField(DynamicProperty.class, (String)"ALL_PROPS", (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static CopyOnWriteArraySet<Runnable> getCallbacks(DynamicProperty property) {
        try {
            return (CopyOnWriteArraySet)FieldUtils.readDeclaredField((Object)property, (String)"callbacks", (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class ServiceCombPropertyUpdateListener
    implements WatchedUpdateListener {
        private final ConcurrentMapConfiguration injectConfig;

        ServiceCombPropertyUpdateListener(ConcurrentMapConfiguration injectConfig) {
            this.injectConfig = injectConfig;
        }

        public void updateConfiguration(WatchedUpdateResult watchedUpdateResult) {
            Map changes;
            Map deletes;
            Map adds = watchedUpdateResult.getAdded();
            if (adds != null) {
                for (Object add : adds.keySet()) {
                    if (!((String)add).startsWith("cse.")) continue;
                    String key = "servicecomb." + ((String)add).substring(((String)add).indexOf(".") + 1);
                    this.injectConfig.addProperty(key, adds.get(add));
                }
            }
            if ((deletes = watchedUpdateResult.getDeleted()) != null) {
                for (String delete : deletes.keySet()) {
                    if (!delete.startsWith("cse.")) continue;
                    this.injectConfig.clearProperty("servicecomb." + delete.substring(delete.indexOf(".") + 1));
                }
            }
            if ((changes = watchedUpdateResult.getChanged()) != null) {
                for (String change : changes.keySet()) {
                    if (!change.startsWith("cse.")) continue;
                    String key = "servicecomb." + change.substring(change.indexOf(".") + 1);
                    this.injectConfig.setProperty(key, changes.get(change));
                }
            }
        }
    }
}

