/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import org.apache.servicecomb.codec.protobuf.definition.OperationProtobuf;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.vertx.client.tcp.AbstractTcpClientPackage;
import org.apache.servicecomb.foundation.vertx.tcp.TcpOutputStream;
import org.apache.servicecomb.transport.highway.HighwayCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighwayClientPackage
extends AbstractTcpClientPackage {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighwayClientPackage.class);
    private Invocation invocation;
    private OperationProtobuf operationProtobuf;

    public HighwayClientPackage(Invocation invocation, OperationProtobuf operationProtobuf, long msRequestTimeout) {
        this.invocation = invocation;
        this.operationProtobuf = operationProtobuf;
        this.setMsRequestTimeout(msRequestTimeout);
    }

    public TcpOutputStream createStream() {
        try {
            return HighwayCodec.encodeRequest(this.msgId, this.invocation, this.operationProtobuf);
        }
        catch (Exception e) {
            String msg = String.format("encode request failed. appid=%s, qualifiedName=%s", this.invocation.getAppId(), this.invocation.getOperationMeta().getMicroserviceQualifiedName());
            LOGGER.error(msg, (Throwable)e);
            throw new Error(msg, e);
        }
    }
}

