/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.config.kie.archaius.sources.KieConfigurationSourceImpl;
import org.apache.servicecomb.config.kie.client.KieUtil;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class KieWatcher {
    public static final KieWatcher INSTANCE = new KieWatcher();
    private KieConfigurationSourceImpl.UpdateHandler updateHandler;
    private String refreshRecord;
    Map<String, Object> lastTimeData;

    private KieWatcher() {
    }

    public void setUpdateHandler(KieConfigurationSourceImpl.UpdateHandler updateHandler) {
        this.updateHandler = updateHandler;
    }

    public void refreshConfigItems(Map<String, Object> remoteItems) {
        String md5Vaule = KieUtil.encrypt(remoteItems.toString());
        if (CollectionUtils.isEmpty(remoteItems)) {
            this.updateHandler.handle("delete", this.lastTimeData);
            this.lastTimeData = remoteItems;
            return;
        }
        if (StringUtils.isEmpty((Object)this.refreshRecord)) {
            this.refreshRecord = md5Vaule;
            this.updateHandler.handle("create", remoteItems);
            this.lastTimeData = remoteItems;
            return;
        }
        if (md5Vaule.equals(this.refreshRecord)) {
            return;
        }
        this.refreshRecord = md5Vaule;
        this.doRefresh(remoteItems);
        this.lastTimeData = remoteItems;
    }

    private void doRefresh(Map<String, Object> remoteItems) {
        HashMap<String, Object> itemsCreated = new HashMap<String, Object>();
        HashMap<String, Object> itemsDeleted = new HashMap<String, Object>();
        HashMap<String, Object> itemsModified = new HashMap<String, Object>();
        for (String itemKey : remoteItems.keySet()) {
            if (!this.lastTimeData.containsKey(itemKey)) {
                itemsCreated.put(itemKey, remoteItems.get(itemKey));
                continue;
            }
            if (remoteItems.get(itemKey).equals(this.lastTimeData.get(itemKey))) continue;
            itemsModified.put(itemKey, remoteItems.get(itemKey));
        }
        for (String itemKey : this.lastTimeData.keySet()) {
            if (remoteItems.containsKey(itemKey)) continue;
            itemsDeleted.put(itemKey, "");
        }
        this.updateHandler.handle("create", itemsCreated);
        this.updateHandler.handle("set", itemsModified);
        this.updateHandler.handle("delete", itemsDeleted);
    }
}

