/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.client;

import com.netflix.config.ConcurrentCompositeConfiguration;
import io.vertx.core.http.HttpVersion;
import org.apache.servicecomb.config.kie.client.KieConfig;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientOptionsSPI;

public class ConfigKieHttpClientOptionsSPI
implements HttpClientOptionsSPI {
    public static final String CLIENT_NAME = "config-kie";

    public String clientName() {
        return CLIENT_NAME;
    }

    public int getOrder() {
        return -200;
    }

    public boolean enabled() {
        return KieConfig.INSTANCE.getServerUri() != null;
    }

    public String getConfigTag() {
        return "kie.consumer";
    }

    public ConcurrentCompositeConfiguration getConfigReader() {
        return KieConfig.getFinalConfig();
    }

    public int getEventLoopPoolSize() {
        return KieConfig.INSTANCE.getEventLoopSize();
    }

    public boolean useSharedVertx() {
        return false;
    }

    public int getInstanceCount() {
        return KieConfig.INSTANCE.getVerticalInstanceCount();
    }

    public boolean isWorker() {
        return false;
    }

    public String getWorkerPoolName() {
        return "pool-worker-kie-client";
    }

    public int getWorkerPoolSize() {
        return 20;
    }

    public HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_1_1;
    }

    public int getConnectTimeoutInMillis() {
        return KieConfig.INSTANCE.getConnectionTimeOut();
    }

    public int getIdleTimeoutInSeconds() {
        return KieConfig.INSTANCE.getIdleTimeoutInSeconds();
    }

    public boolean isTryUseCompression() {
        return false;
    }

    public int getMaxWaitQueueSize() {
        return -1;
    }

    public int getMaxPoolSize() {
        return 5;
    }

    public boolean isKeepAlive() {
        return true;
    }

    public int getMaxHeaderSize() {
        return 8192;
    }

    public int getKeepAliveTimeout() {
        return 60;
    }

    public int getHttp2MultiplexingLimit() {
        return -1;
    }

    public int getHttp2MaxPoolSize() {
        return 1;
    }

    public boolean isUseAlpn() {
        return false;
    }

    public boolean isProxyEnable() {
        return KieConfig.INSTANCE.isProxyEnable();
    }

    public String getProxyHost() {
        return KieConfig.INSTANCE.getProxyHost();
    }

    public int getProxyPort() {
        return KieConfig.INSTANCE.getProxyPort();
    }

    public String getProxyUsername() {
        return KieConfig.INSTANCE.getProxyUsername();
    }

    public String getProxyPassword() {
        return KieConfig.INSTANCE.getProxyPasswd();
    }

    public boolean isSsl() {
        return KieConfig.INSTANCE.getServerUri() != null && KieConfig.INSTANCE.getServerUri().startsWith("https");
    }
}

