/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.api.registry;

import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.config.ConfigurePropertyUtils;
import org.apache.servicecomb.registry.config.MicroservicePropertiesLoader;
import org.apache.servicecomb.registry.definition.MicroserviceDefinition;
import org.apache.servicecomb.registry.version.Version;

public class MicroserviceFactory {
    public Microservice create(String appId, String microserviceName) {
        MicroserviceDefinition microserviceDefinition = MicroserviceDefinition.create(appId, microserviceName);
        return this.create(microserviceDefinition);
    }

    public Microservice create(MicroserviceDefinition microserviceDefinition) {
        Configuration configuration = microserviceDefinition.getConfiguration();
        Microservice microservice = this.createMicroserviceFromDefinition(configuration);
        microservice.setInstance(MicroserviceInstance.createFromDefinition(configuration));
        return microservice;
    }

    private Microservice createMicroserviceFromDefinition(Configuration configuration) {
        Microservice microservice = new Microservice();
        EnvironmentConfiguration envConfig = new EnvironmentConfiguration();
        if (!StringUtils.isEmpty((CharSequence)envConfig.getString("APP_MAPPING")) && !StringUtils.isEmpty((CharSequence)envConfig.getString(envConfig.getString("APP_MAPPING")))) {
            microservice.setAppId(envConfig.getString(envConfig.getString("APP_MAPPING")));
        } else {
            microservice.setAppId(configuration.getString("APPLICATION_ID", "default"));
        }
        if (!StringUtils.isEmpty((CharSequence)envConfig.getString("SERVICE_MAPPING")) && !StringUtils.isEmpty((CharSequence)envConfig.getString(envConfig.getString("SERVICE_MAPPING")))) {
            microservice.setServiceName(envConfig.getString(envConfig.getString("SERVICE_MAPPING")));
        } else {
            microservice.setServiceName(configuration.getString("service_description.name", "defaultMicroservice"));
        }
        String version = !StringUtils.isEmpty((CharSequence)envConfig.getString("VERSION_MAPPING")) && !StringUtils.isEmpty((CharSequence)envConfig.getString(envConfig.getString("VERSION_MAPPING"))) ? envConfig.getString(envConfig.getString("VERSION_MAPPING")) : configuration.getString("service_description.version", "1.0.0.0");
        new Version(version);
        microservice.setVersion(version);
        this.setDescription(configuration, microservice);
        microservice.setLevel(configuration.getString("service_description.role", "FRONT"));
        microservice.setPaths(ConfigurePropertyUtils.getMicroservicePaths(configuration));
        Map<String, String> propertiesMap = MicroservicePropertiesLoader.INSTANCE.loadProperties(configuration);
        microservice.setProperties(propertiesMap);
        microservice.setEnvironment(configuration.getString("service_description.environment", ""));
        if (this.allowCrossApp(propertiesMap)) {
            microservice.setAlias(Microservice.generateAbsoluteMicroserviceName(microservice.getAppId(), microservice.getServiceName()));
        }
        return microservice;
    }

    private void setDescription(Configuration configuration, Microservice microservice) {
        String[] descriptionArray = configuration.getStringArray("service_description.description");
        if (null == descriptionArray || descriptionArray.length < 1) {
            return;
        }
        StringBuilder rawDescriptionBuilder = new StringBuilder();
        for (String desc : descriptionArray) {
            rawDescriptionBuilder.append(desc).append(",");
        }
        microservice.setDescription(rawDescriptionBuilder.substring(0, rawDescriptionBuilder.length() - 1));
    }

    private boolean allowCrossApp(Map<String, String> propertiesMap) {
        return Boolean.parseBoolean(propertiesMap.get("allowCrossApp"));
    }
}

