/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.config.archaius.sources.MicroserviceConfigLoader;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.registry.api.Discovery;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstances;
import org.apache.servicecomb.registry.cache.InstanceCacheManager;
import org.apache.servicecomb.registry.cache.InstanceCacheManagerNew;
import org.apache.servicecomb.registry.consumer.AppManager;
import org.apache.servicecomb.registry.consumer.MicroserviceVersions;
import org.apache.servicecomb.registry.definition.MicroserviceDefinition;

public class DiscoveryManager {
    public static DiscoveryManager INSTANCE = new DiscoveryManager();
    private final List<Discovery> discoveryList;
    private final AppManager appManager = new AppManager();
    private final InstanceCacheManager instanceCacheManager = new InstanceCacheManagerNew(this.appManager);
    private final MicroserviceDefinition microserviceDefinition;

    private DiscoveryManager() {
        this.discoveryList = SPIServiceUtils.getOrLoadSortedService(Discovery.class).stream().filter(discovery -> discovery.enabled()).collect(Collectors.toList());
        MicroserviceConfigLoader loader = ConfigUtil.getMicroserviceConfigLoader();
        this.microserviceDefinition = new MicroserviceDefinition(loader.getConfigModels());
    }

    @VisibleForTesting
    public static void renewInstance() {
        INSTANCE = new DiscoveryManager();
    }

    public MicroserviceInstances findServiceInstances(String appId, String serviceName, String versionRule) {
        MicroserviceInstances result = new MicroserviceInstances();
        result.setNeedRefresh(false);
        result.setMicroserviceNotExist(true);
        this.discoveryList.forEach(discovery -> {
            MicroserviceInstances microserviceInstances = discovery.findServiceInstances(appId, serviceName, versionRule);
            result.mergeMicroserviceInstances(microserviceInstances);
            discovery.setRevision(microserviceInstances.getRevision());
        });
        return result;
    }

    public InstanceCacheManager getInstanceCacheManager() {
        return this.instanceCacheManager;
    }

    public AppManager getAppManager() {
        return this.appManager;
    }

    public MicroserviceInstance getMicroserviceInstance(String serviceId, String instanceId) {
        for (Discovery discovery : this.discoveryList) {
            MicroserviceInstance microserviceInstance = discovery.getMicroserviceInstance(serviceId, instanceId);
            if (microserviceInstance == null) continue;
            return microserviceInstance;
        }
        return null;
    }

    public String getSchema(String microserviceId, Collection<MicroserviceInstance> instances, String schemaId) {
        for (Discovery discovery : this.discoveryList) {
            String schema = discovery.getSchema(microserviceId, instances, schemaId);
            if (schema == null) continue;
            return schema;
        }
        return null;
    }

    public Microservice getMicroservice(String microserviceId) {
        for (Discovery discovery : this.discoveryList) {
            Microservice microservice = discovery.getMicroservice(microserviceId);
            if (microservice == null) continue;
            return microservice;
        }
        return null;
    }

    public List<Microservice> getAllMicroservices() {
        LinkedList<Microservice> result = new LinkedList<Microservice>();
        for (Discovery discovery : this.discoveryList) {
            List<Microservice> microservices = discovery.getAllMicroservices();
            if (microservices == null) continue;
            result.addAll(microservices);
        }
        return result;
    }

    public CompletableFuture<MicroserviceVersions> getOrCreateMicroserviceVersionsAsync(String appId, String microserviceName) {
        return this.appManager.getOrCreateMicroserviceVersionsAsync(appId, microserviceName);
    }

    public MicroserviceVersions getOrCreateMicroserviceVersions(String appId, String microserviceName) {
        return this.appManager.getOrCreateMicroserviceVersions(appId, microserviceName);
    }

    public void destroy() {
        this.discoveryList.forEach(discovery -> discovery.destroy());
    }

    public void run() {
        this.discoveryList.forEach(discovery -> discovery.run());
    }

    public void init() {
        this.discoveryList.forEach(discovery -> discovery.init());
    }
}

