/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.definition;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.models.parameters.Parameter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;

public class RestParam {
    private static final JavaType STRING_ARRAY_TYPE = TypeFactory.defaultInstance().constructArrayType(String.class);
    protected ParamValueProcessor paramProcessor;
    protected String paramName;

    public RestParam(Parameter parameter, Type genericParamType) {
        this.paramName = parameter.getName();
        this.init(parameter, genericParamType);
    }

    public ParamValueProcessor getParamProcessor() {
        return this.paramProcessor;
    }

    public void setParamProcessor(ParamValueProcessor paramProcessor) {
        this.paramProcessor = paramProcessor;
    }

    public String getParamName() {
        return this.paramName;
    }

    protected void init(Parameter parameter, Type genericParamType) {
        String paramType = parameter.getIn();
        ParamValueProcessorCreator creater = (ParamValueProcessorCreator)ParamValueProcessorCreatorManager.INSTANCE.ensureFindValue(paramType);
        this.setParamProcessor(creater.create(parameter, genericParamType));
    }

    public <T> T getValue(Map<String, Object> args) {
        return (T)args.get(this.paramName);
    }

    public String[] getValueAsStrings(Map<String, Object> args) {
        Object value = args.get(this.paramName);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray() || Collection.class.isInstance(value)) {
            return (String[])this.paramProcessor.convertValue(value, STRING_ARRAY_TYPE);
        }
        return new String[]{String.valueOf(value)};
    }
}

