/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.utils;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.commons.lang3.reflect.TypeUtils;

public final class ParamUtils {
    private ParamUtils() {
    }

    public static Type getGenericParameterType(Class<?> mainClass, Method method, Parameter param) {
        Type type = param.getParameterizedType();
        return ParamUtils.getGenericParameterType(mainClass, method.getDeclaringClass(), type);
    }

    public static Type getGenericParameterType(Class<?> mainClass, Class<?> declaringClass, Type type) {
        if (type instanceof Class || mainClass == declaringClass) {
            return type;
        }
        if (type instanceof TypeVariable) {
            Type[] actualTypes;
            TypeVariable<Class<?>>[] typeVariables = declaringClass.getTypeParameters();
            if (mainClass.getGenericSuperclass() != null) {
                actualTypes = ParamUtils.getActualTypes(mainClass.getGenericSuperclass());
            } else {
                Type[] interfaceTypes;
                actualTypes = new Type[]{};
                for (Type t : interfaceTypes = mainClass.getGenericInterfaces()) {
                    Type[] ttTypes = ParamUtils.getActualTypes(t);
                    Type[] tempTypes = new Type[actualTypes.length + ttTypes.length];
                    System.arraycopy(actualTypes, 0, tempTypes, 0, actualTypes.length);
                    System.arraycopy(ttTypes, 0, tempTypes, actualTypes.length, ttTypes.length);
                    actualTypes = tempTypes;
                }
            }
            if (typeVariables.length != actualTypes.length) {
                throw new IllegalArgumentException(String.format("not implement (%s) (%s) (%s), e.g. extends multiple typed interface or too deep inheritance.", mainClass.getName(), declaringClass.getName(), type.getTypeName()));
            }
            for (int i = 0; i < typeVariables.length; ++i) {
                if (typeVariables[i] != type) continue;
                return actualTypes[i];
            }
        } else {
            if (type instanceof GenericArrayType) {
                Class t = (Class)ParamUtils.getGenericParameterType(mainClass, declaringClass, ((GenericArrayType)type).getGenericComponentType());
                return Array.newInstance(t, 0).getClass();
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] targetTypes = new Type[parameterizedType.getActualTypeArguments().length];
                for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                    targetTypes[i] = ParamUtils.getGenericParameterType(mainClass, declaringClass, parameterizedType.getActualTypeArguments()[i]);
                }
                return TypeUtils.parameterize((Class)((Class)parameterizedType.getRawType()), (Type[])targetTypes);
            }
        }
        throw new IllegalArgumentException(String.format("not implement (%s) (%s) (%s)", mainClass.getName(), declaringClass.getName(), type.getTypeName()));
    }

    private static Type[] getActualTypes(Type type) {
        if (type instanceof Class) {
            if (((Class)type).getSuperclass() != null) {
                return ParamUtils.getActualTypes(((Class)type).getSuperclass());
            }
            return ParamUtils.getActualTypes(((Class)type).getGenericInterfaces()[0]);
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return new Type[0];
    }
}

