/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.archaius.sources;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.ConfigMapping;
import org.apache.servicecomb.config.client.ConfigCenterClient;
import org.apache.servicecomb.config.client.ConfigCenterConfig;
import org.apache.servicecomb.config.spi.ConfigCenterConfigurationSource;
import org.apache.servicecomb.deployment.Deployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCenterConfigurationSourceImpl
implements ConfigCenterConfigurationSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCenterConfigurationSourceImpl.class);
    private final Map<String, Object> valueCache = Maps.newConcurrentMap();
    private final List<WatchedUpdateListener> listeners = new CopyOnWriteArrayList<WatchedUpdateListener>();
    private UpdateHandler updateHandler = new UpdateHandler();
    private ConfigCenterClient configCenterClient;

    public boolean isValidSource(Configuration localConfiguration) {
        return Deployment.getSystemBootStrapInfo((String)"ConfigCenter") != null;
    }

    private void init() {
        this.configCenterClient = new ConfigCenterClient(this.updateHandler);
        this.configCenterClient.connectServer();
    }

    public void init(Configuration localConfiguration) {
        ConfigCenterConfig.setConcurrentCompositeConfiguration((ConcurrentCompositeConfiguration)localConfiguration);
        this.init();
    }

    public void destroy() {
        if (this.configCenterClient == null) {
            return;
        }
        this.configCenterClient.destroy();
    }

    public void addUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        if (watchedUpdateListener != null) {
            this.listeners.add(watchedUpdateListener);
        }
    }

    public void removeUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        if (watchedUpdateListener != null) {
            this.listeners.remove(watchedUpdateListener);
        }
    }

    private void updateConfiguration(WatchedUpdateResult result) {
        for (WatchedUpdateListener l : this.listeners) {
            try {
                l.updateConfiguration(result);
            }
            catch (Throwable ex) {
                LOGGER.error("Error in invoking WatchedUpdateListener", ex);
            }
        }
    }

    public Map<String, Object> getCurrentData() throws Exception {
        return this.valueCache;
    }

    public List<WatchedUpdateListener> getCurrentListeners() {
        return this.listeners;
    }

    public class UpdateHandler {
        public void handle(String action, Map<String, Object> parseConfigs) {
            if (parseConfigs == null || parseConfigs.isEmpty()) {
                return;
            }
            Map configuration = ConfigMapping.getConvertedMap(parseConfigs);
            if ("create".equals(action)) {
                ConfigCenterConfigurationSourceImpl.this.valueCache.putAll(configuration);
                ConfigCenterConfigurationSourceImpl.this.updateConfiguration(WatchedUpdateResult.createIncremental((Map)ImmutableMap.copyOf((Map)configuration), null, null));
            } else if ("set".equals(action)) {
                ConfigCenterConfigurationSourceImpl.this.valueCache.putAll(configuration);
                ConfigCenterConfigurationSourceImpl.this.updateConfiguration(WatchedUpdateResult.createIncremental(null, (Map)ImmutableMap.copyOf((Map)configuration), null));
            } else if ("delete".equals(action)) {
                configuration.keySet().forEach(ConfigCenterConfigurationSourceImpl.this.valueCache::remove);
                ConfigCenterConfigurationSourceImpl.this.updateConfiguration(WatchedUpdateResult.createIncremental(null, null, (Map)ImmutableMap.copyOf((Map)configuration)));
            } else {
                LOGGER.error("action: {} is invalid.", (Object)action);
                return;
            }
            LOGGER.warn("Config value cache changed: action:{}; item:{}", (Object)action, configuration.keySet());
        }
    }
}

