/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.archaius.sources;

import com.google.common.collect.ImmutableMap;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.ConfigMapping;
import org.apache.servicecomb.config.client.ApolloClient;
import org.apache.servicecomb.config.client.ApolloConfig;
import org.apache.servicecomb.config.client.ConfigurationAction;
import org.apache.servicecomb.config.spi.ConfigCenterConfigurationSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloConfigurationSourceImpl
implements ConfigCenterConfigurationSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCenterConfigurationSource.class);
    private final Map<String, Object> valueCache = new ConcurrentHashMap<String, Object>();
    private List<WatchedUpdateListener> listeners = new CopyOnWriteArrayList<WatchedUpdateListener>();
    private static final String APOLLO_CONFIG_URL_KEY = "apollo.config.serverUri";
    private final UpdateHandler updateHandler = new UpdateHandler();

    public boolean isValidSource(Configuration localConfiguration) {
        if (localConfiguration.getProperty(APOLLO_CONFIG_URL_KEY) == null) {
            LOGGER.warn("Apollo configuration source is not configured!");
            return false;
        }
        return true;
    }

    public void init(Configuration localConfiguration) {
        ApolloConfig.setConcurrentCompositeConfiguration(localConfiguration);
        this.init();
    }

    private void init() {
        ApolloClient apolloClient = new ApolloClient(this.updateHandler);
        apolloClient.refreshApolloConfig();
    }

    public void addUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        this.listeners.add(watchedUpdateListener);
    }

    public void removeUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        this.listeners.remove(watchedUpdateListener);
    }

    private void updateConfiguration(WatchedUpdateResult result) {
        for (WatchedUpdateListener l : this.listeners) {
            try {
                l.updateConfiguration(result);
            }
            catch (Throwable ex) {
                LOGGER.error("Error in invoking WatchedUpdateListener", ex);
            }
        }
    }

    public Map<String, Object> getCurrentData() throws Exception {
        return this.valueCache;
    }

    public List<WatchedUpdateListener> getCurrentListeners() {
        return this.listeners;
    }

    public class UpdateHandler {
        public void handle(ConfigurationAction action, Map<String, Object> config) {
            if (config == null || config.isEmpty()) {
                return;
            }
            Map configuration = ConfigMapping.getConvertedMap(config);
            if (ConfigurationAction.CREATE.equals((Object)action)) {
                ApolloConfigurationSourceImpl.this.valueCache.putAll(configuration);
                ApolloConfigurationSourceImpl.this.updateConfiguration(WatchedUpdateResult.createIncremental((Map)ImmutableMap.copyOf((Map)configuration), null, null));
            } else if (ConfigurationAction.SET.equals((Object)action)) {
                ApolloConfigurationSourceImpl.this.valueCache.putAll(configuration);
                ApolloConfigurationSourceImpl.this.updateConfiguration(WatchedUpdateResult.createIncremental(null, (Map)ImmutableMap.copyOf((Map)configuration), null));
            } else if (ConfigurationAction.DELETE.equals((Object)action)) {
                configuration.keySet().forEach(ApolloConfigurationSourceImpl.this.valueCache::remove);
                ApolloConfigurationSourceImpl.this.updateConfiguration(WatchedUpdateResult.createIncremental(null, null, (Map)ImmutableMap.copyOf((Map)configuration)));
            } else {
                LOGGER.error("action: {} is invalid.", (Object)action.name());
                return;
            }
            LOGGER.warn("Config value cache changed: action:{}; item:{}", (Object)action.name(), configuration.keySet());
        }
    }
}

