/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.client;

import com.fasterxml.jackson.core.type.TypeReference;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.config.archaius.sources.ConfigCenterConfigurationSourceImpl;
import org.apache.servicecomb.config.client.ConfigCenterConfig;
import org.apache.servicecomb.config.client.ConfigCenterHttpClientOptionsSPI;
import org.apache.servicecomb.config.client.ConnFailEvent;
import org.apache.servicecomb.config.client.ConnSuccEvent;
import org.apache.servicecomb.config.client.MemberDiscovery;
import org.apache.servicecomb.config.client.ParseConfigUtils;
import org.apache.servicecomb.config.client.URIConst;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.auth.SignRequest;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientOptionsSPI;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCenterClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCenterClient.class);
    private static final ConfigCenterConfig CONFIG_CENTER_CONFIG = ConfigCenterConfig.INSTANCE;
    private static final long HEARTBEAT_INTERVAL = 30000L;
    private static final long BOOTUP_WAIT_TIME = 10L;
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private ScheduledExecutorService heartbeatTask = null;
    private int refreshMode = CONFIG_CENTER_CONFIG.getRefreshMode();
    private int refreshInterval = CONFIG_CENTER_CONFIG.getRefreshInterval();
    private int firstRefreshInterval = CONFIG_CENTER_CONFIG.getFirstRefreshInterval();
    private int refreshPort = CONFIG_CENTER_CONFIG.getRefreshPort();
    private String tenantName = CONFIG_CENTER_CONFIG.getTenantName();
    private String serviceName = CONFIG_CENTER_CONFIG.getServiceName();
    private String environment = CONFIG_CENTER_CONFIG.getEnvironment();
    private MemberDiscovery memberDiscovery = new MemberDiscovery(CONFIG_CENTER_CONFIG.getServerUri());
    private ConfigCenterConfigurationSourceImpl.UpdateHandler updateHandler;
    private boolean isWatching = false;
    private final ServiceLoader<AuthHeaderProvider> authHeaderProviders = ServiceLoader.load(AuthHeaderProvider.class);
    private URIConst uriConst = new URIConst();

    public ConfigCenterClient(ConfigCenterConfigurationSourceImpl.UpdateHandler updateHandler) {
        HttpClients.addNewClientPoolManager((HttpClientOptionsSPI)new ConfigCenterHttpClientOptionsSPI());
        this.updateHandler = updateHandler;
    }

    public void connectServer() {
        if (this.refreshMode != 0 && this.refreshMode != 1) {
            LOGGER.error("refreshMode must be 0 or 1.");
            return;
        }
        ParseConfigUtils.getInstance().initWithUpdateHandler(this.updateHandler);
        this.refreshMembers(this.memberDiscovery);
        ConfigRefresh refreshTask = new ConfigRefresh(ParseConfigUtils.getInstance(), this.memberDiscovery);
        refreshTask.run(true);
        this.executor.scheduleWithFixedDelay(refreshTask, this.firstRefreshInterval, this.refreshInterval, TimeUnit.MILLISECONDS);
    }

    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        if (this.heartbeatTask != null) {
            this.heartbeatTask.shutdown();
            this.heartbeatTask = null;
        }
    }

    private void refreshMembers(MemberDiscovery memberDiscovery) {
        if (CONFIG_CENTER_CONFIG.getAutoDiscoveryEnabled()) {
            String configCenter = memberDiscovery.getConfigServer();
            IpPort ipPort = NetUtils.parseIpPortFromURI((String)configCenter);
            HttpClients.getClient((String)"config-center").runOnContext(client -> {
                HttpClientRequest request = client.get(ipPort.getPort(), ipPort.getHostOrIp(), this.uriConst.MEMBERS, rsp -> {
                    if (rsp.statusCode() == HttpResponseStatus.OK.code()) {
                        rsp.bodyHandler(buf -> memberDiscovery.refreshMembers(buf.toJsonObject()));
                    }
                });
                SignRequest signReq = ConfigCenterClient.createSignRequest(request.method().toString(), configCenter + this.uriConst.MEMBERS, new HashMap<String, String>(), null);
                if (ConfigCenterConfig.INSTANCE.getToken() != null) {
                    request.headers().add("X-Auth-Token", ConfigCenterConfig.INSTANCE.getToken());
                }
                this.authHeaderProviders.forEach(provider -> request.headers().addAll(provider.getSignAuthHeaders(signReq)));
                request.exceptionHandler(e -> {
                    LOGGER.error("Fetch member from {} failed. Error message is [{}].", (Object)configCenter, (Object)e.getMessage());
                    this.logIfDnsFailed((Throwable)e);
                });
                request.end();
            });
        }
    }

    public static SignRequest createSignRequest(String method, String endpoint, Map<String, String> headers, InputStream content) {
        String parameters;
        SignRequest signReq = new SignRequest();
        try {
            signReq.setEndpoint(new URI(endpoint));
        }
        catch (URISyntaxException e) {
            LOGGER.warn("set uri failed, uri is {}, message: {}", (Object)endpoint, (Object)e.getMessage());
        }
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        if (endpoint.contains("?") && null != (parameters = endpoint.substring(endpoint.indexOf("?") + 1)) && !"".equals(parameters)) {
            String[] parameterarray;
            for (String p : parameterarray = parameters.split("&")) {
                String key = p.split("=")[0];
                String value = p.split("=")[1];
                if (!queryParams.containsKey(key)) {
                    queryParams.put(key, new String[]{value});
                    continue;
                }
                ArrayList<Object> vals = new ArrayList<Object>(Arrays.asList((Object[])queryParams.get(key)));
                vals.add(value);
                queryParams.put(key, vals.toArray(new String[vals.size()]));
            }
        }
        signReq.setQueryParams(queryParams);
        signReq.setHeaders(headers);
        signReq.setHttpMethod(method);
        signReq.setContent(content);
        return signReq;
    }

    private void logIfDnsFailed(Throwable e) {
        if (e instanceof UnknownHostException) {
            LOGGER.error("DNS resolve failed!", e);
        }
    }

    class ConfigRefresh
    implements Runnable {
        private ParseConfigUtils parseConfigUtils;
        private MemberDiscovery memberdis;

        ConfigRefresh(ParseConfigUtils parseConfigUtils, MemberDiscovery memberdis) {
            this.parseConfigUtils = parseConfigUtils;
            this.memberdis = memberdis;
        }

        public void run(boolean wait) {
            try {
                String configCenter = this.memberdis.getConfigServer();
                if (ConfigCenterClient.this.refreshMode == 1) {
                    this.refreshConfig(configCenter, true);
                } else if (!ConfigCenterClient.this.isWatching) {
                    this.refreshConfig(configCenter, wait);
                    this.doWatch(configCenter);
                }
            }
            catch (Throwable e) {
                LOGGER.error("client refresh thread exception", e);
            }
        }

        @Override
        public void run() {
            this.run(false);
        }

        public void doWatch(String configCenter) throws UnsupportedEncodingException, InterruptedException {
            CountDownLatch waiter = new CountDownLatch(1);
            IpPort ipPort = NetUtils.parseIpPortFromURI((String)configCenter);
            String url = ((ConfigCenterClient)ConfigCenterClient.this).uriConst.REFRESH_ITEMS + "?dimensionsInfo=" + StringUtils.deleteWhitespace((String)URLEncoder.encode(ConfigCenterClient.this.serviceName, "UTF-8"));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-domain-name", ConfigCenterClient.this.tenantName);
            if (ConfigCenterConfig.INSTANCE.getToken() != null) {
                headers.put("X-Auth-Token", ConfigCenterConfig.INSTANCE.getToken());
            }
            headers.put("x-environment", ConfigCenterClient.this.environment);
            HttpClientWithContext vertxHttpClient = HttpClients.getClient((String)"config-center");
            vertxHttpClient.runOnContext(client -> {
                HashMap authHeaders = new HashMap();
                ConfigCenterClient.this.authHeaderProviders.forEach(provider -> authHeaders.putAll(provider.getSignAuthHeaders(ConfigCenterClient.createSignRequest(null, configCenter + url, headers, null))));
                WebSocketConnectOptions options = new WebSocketConnectOptions();
                options.setHost(ipPort.getHostOrIp()).setPort(ConfigCenterClient.this.refreshPort).setURI(url).setHeaders(new CaseInsensitiveHeaders().addAll(headers).addAll(authHeaders));
                client.webSocket(options, asyncResult -> {
                    if (asyncResult.failed()) {
                        LOGGER.error("watcher connect to config center {} refresh port {} failed. Error message is [{}]", new Object[]{configCenter, ConfigCenterClient.this.refreshPort, asyncResult.cause().getMessage()});
                        waiter.countDown();
                    } else {
                        ((WebSocket)asyncResult.result()).exceptionHandler(e -> {
                            LOGGER.error("watch config read fail", e);
                            this.stopHeartBeatThread();
                            ConfigCenterClient.this.isWatching = false;
                        });
                        ((WebSocket)asyncResult.result()).closeHandler(v -> {
                            LOGGER.warn("watching config connection is closed accidentally");
                            this.stopHeartBeatThread();
                            ConfigCenterClient.this.isWatching = false;
                        });
                        ((WebSocket)asyncResult.result()).pongHandler(pong -> {});
                        ((WebSocket)asyncResult.result()).frameHandler(frame -> {
                            Buffer action = frame.binaryData();
                            LOGGER.info("watching config recieved {}", (Object)action);
                            Map mAction = action.toJsonObject().getMap();
                            if ("CREATE".equals(mAction.get("action"))) {
                                this.refreshConfig(configCenter, false);
                            } else if ("MEMBER_CHANGE".equals(mAction.get("action"))) {
                                ConfigCenterClient.this.refreshMembers(this.memberdis);
                            } else {
                                this.parseConfigUtils.refreshConfigItemsIncremental(mAction);
                            }
                        });
                        this.startHeartBeatThread((WebSocket)asyncResult.result());
                        ConfigCenterClient.this.isWatching = true;
                        waiter.countDown();
                    }
                });
            });
            waiter.await();
        }

        private void startHeartBeatThread(WebSocket ws) {
            ConfigCenterClient.this.heartbeatTask = Executors.newScheduledThreadPool(1);
            ConfigCenterClient.this.heartbeatTask.scheduleWithFixedDelay(() -> this.sendHeartbeat(ws), 30000L, 30000L, TimeUnit.MILLISECONDS);
        }

        private void stopHeartBeatThread() {
            if (ConfigCenterClient.this.heartbeatTask != null) {
                ConfigCenterClient.this.heartbeatTask.shutdownNow();
            }
        }

        private void sendHeartbeat(WebSocket ws) {
            try {
                ws.writeFrame((WebSocketFrame)new WebSocketFrameImpl(FrameType.PING));
                EventManager.post((Object)new ConnSuccEvent());
            }
            catch (IllegalStateException e) {
                EventManager.post((Object)new ConnFailEvent("heartbeat fail, " + e.getMessage()));
                LOGGER.error("heartbeat fail", (Throwable)e);
            }
        }

        public void refreshConfig(String configcenter, boolean wait) {
            CountDownLatch latch = new CountDownLatch(1);
            String encodeServiceName = "";
            try {
                encodeServiceName = URLEncoder.encode(StringUtils.deleteWhitespace((String)ConfigCenterClient.this.serviceName), StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("encode failed. Error message: {}", (Object)e.getMessage());
                encodeServiceName = StringUtils.deleteWhitespace((String)ConfigCenterClient.this.serviceName);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Updating remote config...");
            }
            String path = ((ConfigCenterClient)ConfigCenterClient.this).uriConst.ITEMS + "?dimensionsInfo=" + encodeServiceName + "&revision=" + ParseConfigUtils.getInstance().getCurrentVersionInfo();
            HttpClients.getClient((String)"config-center").runOnContext(client -> {
                IpPort ipPort = NetUtils.parseIpPortFromURI((String)configcenter);
                HttpClientRequest request = client.get(ipPort.getPort(), ipPort.getHostOrIp(), path, rsp -> {
                    if (rsp.statusCode() == HttpResponseStatus.OK.code()) {
                        rsp.bodyHandler(buf -> {
                            try {
                                this.parseConfigUtils.refreshConfigItems((Map)JsonUtils.OBJ_MAPPER.readValue(buf.toString(), (TypeReference)new TypeReference<LinkedHashMap<String, Map<String, Object>>>(){}));
                                EventManager.post((Object)new ConnSuccEvent());
                            }
                            catch (IOException e) {
                                EventManager.post((Object)new ConnFailEvent("config update result parse fail " + e.getMessage()));
                                LOGGER.error("Config update from {} failed. Error message is [{}].", (Object)configcenter, (Object)e.getMessage());
                            }
                            latch.countDown();
                        });
                    } else if (rsp.statusCode() == HttpResponseStatus.NOT_MODIFIED.code()) {
                        EventManager.post((Object)new ConnSuccEvent());
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Updating remote config is done. the revision {} has no change", (Object)ParseConfigUtils.getInstance().getCurrentVersionInfo());
                        }
                        latch.countDown();
                    } else {
                        rsp.bodyHandler(buf -> {
                            LOGGER.error("Server error message is [{}].", buf);
                            latch.countDown();
                        });
                        EventManager.post((Object)new ConnFailEvent("fetch config fail"));
                        LOGGER.error("Config update from {} failed.", (Object)configcenter);
                    }
                }).setTimeout(9000L);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("x-domain-name", ConfigCenterClient.this.tenantName);
                if (ConfigCenterConfig.INSTANCE.getToken() != null) {
                    headers.put("X-Auth-Token", ConfigCenterConfig.INSTANCE.getToken());
                }
                headers.put("x-environment", ConfigCenterClient.this.environment);
                request.headers().addAll(headers);
                ConfigCenterClient.this.authHeaderProviders.forEach(provider -> request.headers().addAll(provider.getSignAuthHeaders(ConfigCenterClient.createSignRequest(request.method().toString(), configcenter + path, headers, null))));
                request.exceptionHandler(e -> {
                    EventManager.post((Object)new ConnFailEvent("fetch config fail"));
                    LOGGER.error("Config update from {} failed. Error message is [{}].", (Object)configcenter, (Object)e.getMessage());
                    ConfigCenterClient.this.logIfDnsFailed(e);
                    latch.countDown();
                });
                request.end();
            });
            if (wait) {
                try {
                    latch.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOGGER.warn(e.getMessage());
                }
            }
        }
    }
}

