/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.locator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.common.rest.definition.RestOperationComparator;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.locator.OperationGroup;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroservicePaths {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroservicePaths.class);
    protected Map<String, OperationGroup> staticPathOperations = new HashMap<String, OperationGroup>();
    protected List<RestOperationMeta> dynamicPathOperationsList = new ArrayList<RestOperationMeta>();

    public void sortPath() {
        RestOperationComparator comparator = new RestOperationComparator();
        Collections.sort(this.dynamicPathOperationsList, comparator);
    }

    public void addResource(RestOperationMeta swaggerRestOperation) {
        if (swaggerRestOperation.isAbsoluteStaticPath()) {
            this.addStaticPathResource(swaggerRestOperation);
            return;
        }
        this.dynamicPathOperationsList.add(swaggerRestOperation);
    }

    protected void addStaticPathResource(RestOperationMeta operation) {
        String httpMethod = operation.getHttpMethod();
        String path = operation.getAbsolutePath();
        OperationGroup group = this.staticPathOperations.get(path);
        if (group == null) {
            group = new OperationGroup();
            group.register(httpMethod, operation);
            this.staticPathOperations.put(path, group);
            return;
        }
        if (group.findValue(httpMethod) == null) {
            group.register(httpMethod, operation);
            return;
        }
        throw new ServiceCombException(String.format("operation with url %s, method %s is duplicated.", path, httpMethod));
    }

    public Map<String, OperationGroup> getStaticPathOperationMap() {
        return this.staticPathOperations;
    }

    public List<RestOperationMeta> getDynamicPathOperationList() {
        return this.dynamicPathOperationsList;
    }

    public void printPaths() {
        for (Map.Entry<String, OperationGroup> entry : this.staticPathOperations.entrySet()) {
            OperationGroup operationGroup = entry.getValue();
            this.printPath(operationGroup.values());
        }
        this.printPath(this.getDynamicPathOperationList());
    }

    protected void printPath(Collection<RestOperationMeta> operations) {
        for (RestOperationMeta operation : operations) {
            SwaggerProducerOperation producerOperation = operation.getOperationMeta().getSwaggerProducerOperation();
            LOGGER.info("Swagger mapped \"{[{}], method=[{}], produces={}}\" onto {}", new Object[]{operation.getAbsolutePath(), operation.getHttpMethod(), operation.getProduces(), producerOperation.getProducerMethod()});
        }
    }
}

