/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication.provider;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.authentication.RSAAuthenticationToken;
import org.apache.servicecomb.authentication.provider.AccessController;
import org.apache.servicecomb.foundation.common.utils.RSAUtils;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.cache.MicroserviceInstanceCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAProviderTokenManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSAProviderTokenManager.class);
    private static Cache<RSAAuthenticationToken, Boolean> validatedToken = CacheBuilder.newBuilder().expireAfterAccess((long)RSAProviderTokenManager.getExpiredTime(), TimeUnit.MILLISECONDS).build();
    private AccessController accessController = new AccessController();

    public boolean valid(String token) {
        try {
            RSAAuthenticationToken rsaToken = RSAAuthenticationToken.fromStr(token);
            if (null == rsaToken) {
                LOGGER.error("token format is error, perhaps you need to set auth handler at consumer");
                return false;
            }
            if (this.tokenExpired(rsaToken)) {
                LOGGER.error("token is expired");
                return false;
            }
            if (RSAProviderTokenManager.getValidatedToken().asMap().containsKey(rsaToken)) {
                return this.accessController.isAllowed(MicroserviceInstanceCache.getOrCreate((String)rsaToken.getServiceId()));
            }
            if (this.isValidToken(rsaToken) && !this.tokenExpired(rsaToken)) {
                RSAProviderTokenManager.getValidatedToken().put((Object)rsaToken, (Object)true);
                return this.accessController.isAllowed(MicroserviceInstanceCache.getOrCreate((String)rsaToken.getServiceId()));
            }
            return false;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            LOGGER.error("verify error", (Throwable)e);
            return false;
        }
    }

    public boolean isValidToken(RSAAuthenticationToken rsaToken) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        String sign = rsaToken.getSign();
        String content = rsaToken.plainToken();
        String publicKey = this.getPublicKey(rsaToken.getInstanceId(), rsaToken.getServiceId());
        return RSAUtils.verify((String)publicKey, (String)sign, (String)content);
    }

    public static int getExpiredTime() {
        return 3600000;
    }

    private boolean tokenExpired(RSAAuthenticationToken rsaToken) {
        long generateTime = rsaToken.getGenerateTime();
        long expired = generateTime + 86400000L + 900000L;
        long now = System.currentTimeMillis();
        return now > expired;
    }

    private String getPublicKey(String instanceId, String serviceId) {
        MicroserviceInstance instances = MicroserviceInstanceCache.getOrCreate((String)serviceId, (String)instanceId);
        if (instances != null) {
            return (String)instances.getProperties().get("publickey");
        }
        LOGGER.error("not instance found {}-{}, maybe attack", (Object)instanceId, (Object)serviceId);
        return "";
    }

    public static Cache<RSAAuthenticationToken, Boolean> getValidatedToken() {
        return validatedToken;
    }
}

