/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.nacos.client;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.servicecomb.config.nacos.archaius.sources.NacosConfigurationSourceImpl;
import org.apache.servicecomb.config.nacos.client.ConfigurationAction;
import org.apache.servicecomb.config.nacos.client.NacosConfig;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosClient.class);
    private static final NacosConfig NACOS_CONFIG = NacosConfig.INSTANCE;
    private static final Map<String, Object> originalConfigMap = new ConcurrentHashMap<String, Object>();
    private final String serverAddr = NACOS_CONFIG.getServerAddr();
    private final String dataId = NACOS_CONFIG.getDataId();
    private final String group = NACOS_CONFIG.getGroup();
    private final NacosConfigurationSourceImpl.UpdateHandler updateHandler;

    public NacosClient(NacosConfigurationSourceImpl.UpdateHandler updateHandler) {
        this.updateHandler = updateHandler;
    }

    public void refreshNacosConfig() {
        new ConfigRefresh(this.serverAddr, this.dataId, this.group).refreshConfig();
    }

    class ConfigRefresh {
        private final String serverAddr;
        private final String dataId;
        private final String group;

        ConfigRefresh(String serverAddr, String dataId, String group) {
            this.serverAddr = serverAddr;
            this.dataId = dataId;
            this.group = group;
        }

        void refreshConfig() {
            Properties properties = new Properties();
            properties.put("serverAddr", this.serverAddr);
            properties.put("dataId", this.dataId);
            properties.put("group", this.group);
            try {
                ConfigService configService = NacosFactory.createConfigService((Properties)properties);
                String content = configService.getConfig(this.dataId, this.group, 5000L);
                Map body = (Map)JsonUtils.OBJ_MAPPER.readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(){});
                this.refreshConfigItems(body);
                configService.addListener(this.dataId, this.group, new Listener(){

                    public void receiveConfigInfo(String configInfo) {
                        LOGGER.info("receive from nacos:" + configInfo);
                        try {
                            Map body = (Map)JsonUtils.OBJ_MAPPER.readValue(configInfo, (TypeReference)new TypeReference<Map<String, Object>>(){});
                            ConfigRefresh.this.refreshConfigItems(body);
                        }
                        catch (IOException e) {
                            LOGGER.error("JsonObject parse config center response error: ", (Throwable)e);
                        }
                    }

                    public Executor getExecutor() {
                        return null;
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Receive nacos config error: ", (Throwable)e);
            }
        }

        private void refreshConfigItems(Map<String, Object> map) {
            this.compareChangedConfig(originalConfigMap, map);
            originalConfigMap.clear();
            originalConfigMap.putAll(map);
        }

        void compareChangedConfig(Map<String, Object> before, Map<String, Object> after) {
            HashMap<String, Object> itemsCreated = new HashMap<String, Object>();
            HashMap<String, Object> itemsDeleted = new HashMap<String, Object>();
            HashMap<String, Object> itemsModified = new HashMap<String, Object>();
            if (before == null || before.isEmpty()) {
                NacosClient.this.updateHandler.handle(ConfigurationAction.CREATE, after);
                return;
            }
            if (after == null || after.isEmpty()) {
                NacosClient.this.updateHandler.handle(ConfigurationAction.DELETE, before);
                return;
            }
            after.entrySet().forEach(stringObjectEntry -> {
                String itemKey = (String)stringObjectEntry.getKey();
                Object itemValue = stringObjectEntry.getValue();
                if (!before.containsKey(itemKey)) {
                    itemsCreated.put(itemKey, itemValue);
                } else if (!itemValue.equals(before.get(itemKey))) {
                    itemsModified.put(itemKey, itemValue);
                }
            });
            for (String itemKey : before.keySet()) {
                if (after.containsKey(itemKey)) continue;
                itemsDeleted.put(itemKey, "");
            }
            NacosClient.this.updateHandler.handle(ConfigurationAction.CREATE, itemsCreated);
            NacosClient.this.updateHandler.handle(ConfigurationAction.SET, itemsModified);
            NacosClient.this.updateHandler.handle(ConfigurationAction.DELETE, itemsDeleted);
        }
    }
}

