/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core;

import com.netflix.config.DynamicPropertyFactory;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrap;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.registry.GlobalRegistry;
import org.apache.servicecomb.metrics.core.publish.HealthCheckerRestPublisher;
import org.apache.servicecomb.metrics.core.publish.MetricsRestPublisher;
import org.apache.servicecomb.metrics.core.publish.SlowInvocationLogger;

public class MetricsBootListener
implements BootListener {
    private MetricsBootstrap metricsBootstrap = new MetricsBootstrap();
    private SlowInvocationLogger slowInvocationLogger;

    public MetricsBootstrap getMetricsBootstrap() {
        return this.metricsBootstrap;
    }

    public SlowInvocationLogger getSlowInvocationLogger() {
        return this.slowInvocationLogger;
    }

    public void onBeforeProducerProvider(BootListener.BootEvent event) {
        if (!DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.metrics.endpoint.enabled", true).get()) {
            return;
        }
        event.getScbEngine().getProducerProviderManager().addProducerMeta("healthEndpoint", (Object)new HealthCheckerRestPublisher());
        MetricsRestPublisher metricsRestPublisher = (MetricsRestPublisher)SPIServiceUtils.getTargetService(MetricsInitializer.class, MetricsRestPublisher.class);
        event.getScbEngine().getProducerProviderManager().addProducerMeta("metricsEndpoint", (Object)metricsRestPublisher);
    }

    public void onAfterRegistry(BootListener.BootEvent event) {
        this.slowInvocationLogger = new SlowInvocationLogger(event.getScbEngine());
        this.metricsBootstrap.start(new GlobalRegistry(), EventManager.getEventBus());
    }

    public void onBeforeClose(BootListener.BootEvent event) {
        this.metricsBootstrap.shutdown();
    }
}

