/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig.server;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.zeroconfig.server.ServerMicroserviceInstance;
import org.apache.servicecomb.zeroconfig.server.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroConfigRegistryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroConfigRegistryService.class);

    public void registerMicroserviceInstance(Map<String, String> serviceAttributeMap) {
        String instanceId = serviceAttributeMap.get("instanceId");
        String serviceId = serviceAttributeMap.get("serviceId");
        String serviceName = serviceAttributeMap.get("serviceName");
        if (serviceId == null || serviceName == null || instanceId == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + serviceId + "Invalid serviceName, serviceName=" + serviceName + "Invalid instanceId, instanceId=" + instanceId);
        }
        ServerMicroserviceInstance newServerMicroserviceInstance = ServerUtil.convertToServerMicroserviceInstance(serviceAttributeMap);
        Map innerInstanceMap = ServerUtil.microserviceInstanceMap.computeIfAbsent(serviceId, id -> new ConcurrentHashMap());
        if (innerInstanceMap.containsKey(instanceId)) {
            LOGGER.info("ServiceId: {}, instanceId: {} already exists", (Object)serviceId, (Object)instanceId);
        } else {
            LOGGER.info("Register a new instance for  serviceId: {}, instanceId: {}, status: {}, name: {}", new Object[]{serviceId, instanceId, newServerMicroserviceInstance.getStatus(), newServerMicroserviceInstance.getServiceName()});
            innerInstanceMap.put(instanceId, newServerMicroserviceInstance);
        }
    }

    public void unregisterMicroserviceInstance(Map<String, String> serviceAttributeMap) {
        String unregisterServiceId = serviceAttributeMap.get("serviceId");
        String unregisterInstanceId = serviceAttributeMap.get("instanceId");
        if (unregisterServiceId == null || unregisterInstanceId == null) {
            throw new IllegalArgumentException("Invalid unregisterServiceId, unregisterServiceId=" + unregisterServiceId + "Invalid unregisterInstanceId, unregisterInstanceId=" + unregisterInstanceId);
        }
        ServerUtil.microserviceInstanceMap.computeIfPresent(unregisterServiceId, (serviceId, instanceIdMap) -> {
            instanceIdMap.computeIfPresent(unregisterInstanceId, (instanceId, instance) -> {
                LOGGER.info("Successfully unregistered/remove serviceId: {}, instanceId: {} from server side", (Object)unregisterServiceId, (Object)unregisterInstanceId);
                return null;
            });
            return !instanceIdMap.isEmpty() ? instanceIdMap : null;
        });
    }

    public ServerMicroserviceInstance findServiceInstance(String serviceId, String instanceId) {
        Map<String, ServerMicroserviceInstance> serverMicroserviceInstanceMap = ServerUtil.microserviceInstanceMap.get(serviceId);
        if (serverMicroserviceInstanceMap == null || serverMicroserviceInstanceMap.isEmpty()) {
            return null;
        }
        return serverMicroserviceInstanceMap.get(instanceId);
    }

    public List<ServerMicroserviceInstance> getMicroserviceInstance(String consumerId, String providerId) {
        Map<String, ServerMicroserviceInstance> instanceIdMap = ServerUtil.microserviceInstanceMap.get(providerId);
        if (instanceIdMap == null || instanceIdMap.isEmpty()) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + providerId);
        }
        return new ArrayList<ServerMicroserviceInstance>(instanceIdMap.values());
    }

    public void heartbeat(Map<String, String> heartbeatEventMap) {
        String serviceId = heartbeatEventMap.get("serviceId");
        String instanceId = heartbeatEventMap.get("instanceId");
        Map<String, ServerMicroserviceInstance> serverMicroserviceInstanceMap = ServerUtil.microserviceInstanceMap.get(serviceId);
        if (serverMicroserviceInstanceMap != null && serverMicroserviceInstanceMap.containsKey(instanceId)) {
            ServerMicroserviceInstance instance = serverMicroserviceInstanceMap.get(instanceId);
            instance.setLastHeartbeatTimeStamp(Instant.now());
        } else {
            heartbeatEventMap.put("event", "register");
            LOGGER.info("Received HEARTBEAT event from serviceId: {}, instancdId: {} for the first time. Register it instead.", (Object)serviceId, (Object)instanceId);
            this.registerMicroserviceInstance(heartbeatEventMap);
        }
    }

    public boolean heartbeat(String microserviceId, String microserviceInstanceId) {
        Map<String, ServerMicroserviceInstance> serverMicroserviceInstanceMap = ServerUtil.microserviceInstanceMap.get(microserviceId);
        return serverMicroserviceInstanceMap != null && serverMicroserviceInstanceMap.containsKey(microserviceInstanceId);
    }

    public ServerMicroserviceInstance getMicroservice(String microserviceId) {
        Map<String, ServerMicroserviceInstance> instanceIdMap = ServerUtil.microserviceInstanceMap.get(microserviceId);
        if (instanceIdMap != null) {
            ArrayList<ServerMicroserviceInstance> serverMicroserviceInstanceList = new ArrayList<ServerMicroserviceInstance>(instanceIdMap.values());
            return (ServerMicroserviceInstance)serverMicroserviceInstanceList.get(0);
        }
        return null;
    }

    public List<ServerMicroserviceInstance> findServiceInstances(String appId, String serviceName) {
        ArrayList<ServerMicroserviceInstance> resultInstanceList = new ArrayList<ServerMicroserviceInstance>();
        ServerUtil.microserviceInstanceMap.forEach((serviceId, instanceIdMap) -> instanceIdMap.forEach((instanceId, instance) -> {
            if (appId.equals(instance.getAppId()) && serviceName.equals(instance.getServiceName())) {
                resultInstanceList.add((ServerMicroserviceInstance)instance);
            }
        }));
        return resultInstanceList;
    }
}

