/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.Filter;
import org.apache.servicecomb.core.filter.FilterMeta;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.ContextUtils;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterMeta(name="producer-operation", invocationType={InvocationType.PRODUCER})
public class ProducerOperationFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerOperationFilter.class);

    @Override
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        invocation.onBusinessMethodStart();
        SwaggerProducerOperation producerOperation = invocation.getOperationMeta().getSwaggerProducerOperation();
        Object instance = producerOperation.getProducerInstance();
        Method method = producerOperation.getProducerMethod();
        Object[] args = invocation.toProducerArguments();
        return ((CompletableFuture)this.invoke(invocation, instance, method, args).thenApply(result -> this.convertResultToResponse(invocation, producerOperation, result))).whenComplete((response, throwable) -> this.whenComplete(invocation, (Throwable)throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Object> invoke(Invocation invocation, Object instance, Method method, Object[] args) {
        ContextUtils.setInvocationContext((InvocationContext)invocation);
        try {
            Object result = method.invoke(instance, args);
            if (result instanceof CompletableFuture) {
                CompletableFuture completableFuture = (CompletableFuture)result;
                return completableFuture;
            }
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(result);
            return completableFuture;
        }
        catch (Throwable e) {
            CompletableFuture completableFuture = AsyncUtils.completeExceptionally(Exceptions.unwrap(e));
            return completableFuture;
        }
        finally {
            ContextUtils.removeInvocationContext();
        }
    }

    private Response convertResultToResponse(Invocation invocation, SwaggerProducerOperation producerOperation, Object result) {
        return producerOperation.getResponseMapper().mapResponse(invocation.getStatus(), result);
    }

    private void whenComplete(Invocation invocation, Throwable throwable) {
        Object unwrapped;
        if (throwable != null && this.shouldPrintErrorLog((Throwable)(unwrapped = Exceptions.unwrap(throwable)))) {
            LOGGER.error("unexpected error, invocation={},", (Object)invocation.getInvocationQualifiedName(), unwrapped);
        }
        invocation.onBusinessMethodFinish();
        invocation.onBusinessFinish();
    }

    protected boolean shouldPrintErrorLog(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        return !(throwable instanceof InvocationException);
    }
}

