/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.Filter;
import org.apache.servicecomb.core.filter.impl.TransportFilters;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.swagger.invocation.Response;

public class FilterNode {
    public static final FilterNode EMPTY = new FilterNode(null){

        @Override
        public CompletableFuture<Response> onFilter(Invocation invocation1) {
            return CompletableFuture.completedFuture(Response.ok(null));
        }
    };
    private final Filter filter;
    private FilterNode nextNode;

    public static FilterNode buildChain(Filter ... filters) {
        return FilterNode.buildChain(Arrays.asList(filters));
    }

    public static FilterNode buildChain(List<Filter> filters) {
        List filterNodes = filters.stream().map(FilterNode::new).collect(Collectors.toList());
        for (int idx = 0; idx < filterNodes.size() - 1; ++idx) {
            FilterNode currentNode = (FilterNode)filterNodes.get(idx);
            FilterNode nextNode = (FilterNode)filterNodes.get(idx + 1);
            currentNode.setNextNode(nextNode);
            if (!(currentNode.filter instanceof TransportFilters)) continue;
            FilterNode.mergeToChain((TransportFilters)currentNode.filter, nextNode);
        }
        return (FilterNode)filterNodes.get(0);
    }

    private static void mergeToChain(TransportFilters filter, FilterNode nextNode) {
        for (FilterNode node : filter.getChainByTransport().values()) {
            while (node.nextNode != null) {
                node = node.nextNode;
            }
            node.nextNode = nextNode;
        }
    }

    public FilterNode(Filter filter) {
        this.filter = filter;
    }

    private void setNextNode(FilterNode nextNode) {
        this.nextNode = nextNode;
    }

    public CompletableFuture<Response> onFilter(Invocation invocation) {
        if (!this.filter.enabled()) {
            return this.nextNode.onFilter(invocation);
        }
        return AsyncUtils.tryCatch(() -> this.filter.onFilter(invocation, this.nextNode)).thenApply(this::rethrowExceptionInResponse);
    }

    private Response rethrowExceptionInResponse(Response response) {
        if (response.isFailed() && response.getResult() instanceof Throwable) {
            AsyncUtils.rethrow((Throwable)((Throwable)response.getResult()));
        }
        return response;
    }
}

