/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.filter.Filter;
import org.apache.servicecomb.core.filter.FilterManager;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.FilterProvider;
import org.apache.servicecomb.core.filter.config.FilterChainsConfig;
import org.apache.servicecomb.core.filter.config.TransportFiltersConfig;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FilterChainsManager {
    private TransportFiltersConfig transportFiltersConfig;
    private FilterManager filterManager;
    private FilterChainsConfig consumerChainsConfig;
    private FilterChainsConfig producerChainsConfig;
    private boolean enabled;

    @Autowired
    public FilterChainsManager setTransportFiltersConfig(TransportFiltersConfig transportFiltersConfig) {
        this.transportFiltersConfig = transportFiltersConfig;
        return this;
    }

    @Value(value="${servicecomb.filter-chains.enabled:false}")
    public FilterChainsManager setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public FilterManager getFilterManager() {
        return this.filterManager;
    }

    @Autowired
    public FilterChainsManager setFilterManager(FilterManager filterManager) {
        this.filterManager = filterManager;
        return this;
    }

    public FilterChainsManager init(SCBEngine engine) {
        this.transportFiltersConfig.load();
        this.filterManager.init(engine);
        this.consumerChainsConfig = new FilterChainsConfig(this.transportFiltersConfig, InvocationType.CONSUMER);
        this.producerChainsConfig = new FilterChainsConfig(this.transportFiltersConfig, InvocationType.PRODUCER);
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public FilterChainsManager addProviders(FilterProvider ... providers) {
        return this.addProviders(Arrays.asList(providers));
    }

    public FilterChainsManager addProviders(Collection<FilterProvider> providers) {
        this.filterManager.addProviders(providers);
        return this;
    }

    public FilterNode createConsumerFilterChain(String microservice) {
        return this.createFilterNode(this.consumerChainsConfig, microservice);
    }

    public FilterNode createProducerFilterChain(String microservice) {
        return this.createFilterNode(this.producerChainsConfig, microservice);
    }

    public List<Filter> createConsumerFilters(String microservice) {
        return this.createFilters(this.consumerChainsConfig, microservice);
    }

    public List<Filter> createProducerFilters(String microservice) {
        return this.createFilters(this.producerChainsConfig, microservice);
    }

    public String collectResolvedChains() {
        StringBuilder sb = new StringBuilder();
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"producer filters: %s", (Object[])new Object[]{this.filterManager.getProducerFilters()});
        this.collectChainsByInvocationType(sb, this.producerChainsConfig, InvocationType.PRODUCER);
        return StringBuilderUtils.deleteLast((StringBuilder)sb, (int)1).toString();
    }

    private void collectChainsByInvocationType(StringBuilder sb, FilterChainsConfig chainsConfig, InvocationType invocationType) {
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"%s chains:", (Object[])new Object[]{invocationType.name().toLowerCase(Locale.US)});
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  default: %s", (Object[])new Object[]{chainsConfig.getDefaultChain()});
        for (Map.Entry<String, List<Object>> entry : chainsConfig.getMicroserviceChains().entrySet()) {
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  %s: %s", (Object[])new Object[]{entry.getKey(), entry.getValue()});
        }
    }

    private FilterNode createFilterNode(FilterChainsConfig chainsConfig, String microservice) {
        if (!this.enabled) {
            return FilterNode.EMPTY;
        }
        List<Filter> filters = this.createFilters(chainsConfig, microservice);
        return FilterNode.buildChain(filters);
    }

    private List<Filter> createFilters(FilterChainsConfig chainsConfig, String microservice) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        List<Object> chain = chainsConfig.findChain(microservice);
        return this.filterManager.createFilters(chain);
    }
}

