/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.executor;

import com.netflix.config.DynamicPropertyFactory;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.core.executor.GroupThreadFactory;
import org.apache.servicecomb.core.executor.LinkedBlockingQueueEx;
import org.apache.servicecomb.core.executor.ThreadPoolExecutorEx;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupExecutor
implements Executor,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupExecutor.class);
    public static final String KEY_GROUP = "servicecomb.executor.default.group";
    public static final String KEY_OLD_MAX_THREAD = "servicecomb.executor.default.thread-per-group";
    public static final String KEY_CORE_THREADS = "servicecomb.executor.default.coreThreads-per-group";
    public static final String KEY_MAX_THREADS = "servicecomb.executor.default.maxThreads-per-group";
    public static final String KEY_MAX_IDLE_SECOND = "servicecomb.executor.default.maxIdleSecond-per-group";
    public static final String KEY_MAX_QUEUE_SIZE = "servicecomb.executor.default.maxQueueSize-per-group";
    private static final AtomicBoolean LOG_PRINTED = new AtomicBoolean();
    protected String groupName;
    protected int groupCount;
    protected int coreThreads;
    protected int maxThreads;
    protected int maxIdleInSecond;
    protected int maxQueueSize;
    private List<ExecutorService> executorList = new ArrayList<ExecutorService>();
    private AtomicInteger index = new AtomicInteger();
    private Map<Long, Executor> threadExecutorMap = new ConcurrentHashMapEx();

    public GroupExecutor init() {
        return this.init("group");
    }

    public GroupExecutor init(String groupName) {
        this.groupName = groupName;
        this.initConfig();
        for (int groupIdx = 0; groupIdx < this.groupCount; ++groupIdx) {
            GroupThreadFactory factory = new GroupThreadFactory(groupName + groupIdx);
            ThreadPoolExecutorEx executor = new ThreadPoolExecutorEx(this.coreThreads, this.maxThreads, this.maxIdleInSecond, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueueEx<Runnable>(this.maxQueueSize), (ThreadFactory)factory);
            this.executorList.add(executor);
        }
        return this;
    }

    public void initConfig() {
        if (LOG_PRINTED.compareAndSet(false, true)) {
            LOGGER.info("thread pool rules:\n1.use core threads.\n2.if all core threads are busy, then create new thread.\n3.if thread count reach the max limitation, then queue the request.\n4.if queue is full, and threads count is max, then reject the request.");
        }
        this.groupCount = DynamicPropertyFactory.getInstance().getIntProperty(KEY_GROUP, 2).get();
        this.coreThreads = DynamicPropertyFactory.getInstance().getIntProperty(KEY_CORE_THREADS, 25).get();
        this.maxThreads = DynamicPropertyFactory.getInstance().getIntProperty(KEY_MAX_THREADS, -1).get();
        if (this.maxThreads <= 0) {
            this.maxThreads = DynamicPropertyFactory.getInstance().getIntProperty(KEY_OLD_MAX_THREAD, -1).get();
            if (this.maxThreads > 0) {
                LOGGER.warn("{} is deprecated, recommended to use {}.", (Object)KEY_OLD_MAX_THREAD, (Object)KEY_MAX_THREADS);
            } else {
                this.maxThreads = 100;
            }
        }
        if (this.coreThreads > this.maxThreads) {
            LOGGER.warn("coreThreads is bigger than maxThreads, change from {} to {}.", (Object)this.coreThreads, (Object)this.maxThreads);
            this.coreThreads = this.maxThreads;
        }
        this.maxIdleInSecond = DynamicPropertyFactory.getInstance().getIntProperty(KEY_MAX_IDLE_SECOND, 60).get();
        this.maxQueueSize = DynamicPropertyFactory.getInstance().getIntProperty(KEY_MAX_QUEUE_SIZE, Integer.MAX_VALUE).get();
        LOGGER.info("executor name={}, group={}. per group settings, coreThreads={}, maxThreads={}, maxIdleInSecond={}, maxQueueSize={}.", new Object[]{this.groupName, this.groupCount, this.coreThreads, this.maxThreads, this.maxIdleInSecond, this.maxQueueSize});
    }

    public List<ExecutorService> getExecutorList() {
        return this.executorList;
    }

    @Override
    public void execute(Runnable command) {
        long threadId = Thread.currentThread().getId();
        Executor executor = this.threadExecutorMap.computeIfAbsent(threadId, this::chooseExecutor);
        executor.execute(command);
    }

    private Executor chooseExecutor(long threadId) {
        int idx = this.index.getAndIncrement() % this.executorList.size();
        return this.executorList.get(idx);
    }

    @Override
    public void close() {
        for (ExecutorService executorService : this.executorList) {
            executorService.shutdown();
        }
        this.executorList.clear();
    }
}

