/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.exception.converter;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.ExceptionConverter;
import org.apache.servicecomb.core.exception.converter.ValidateDetail;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class ConstraintViolationExceptionConverter
implements ExceptionConverter<ConstraintViolationException> {
    public static final short ORDER = Short.MAX_VALUE;
    public static final String KEY_CODE = "servicecomb.filters.validate.code";
    private DynamicStringProperty code;

    public ConstraintViolationExceptionConverter() {
        this.refreshCode();
    }

    @VisibleForTesting
    public void refreshCode() {
        this.code = DynamicPropertyFactory.getInstance().getStringProperty(KEY_CODE, "SCB.00000003");
    }

    public int getOrder() {
        return Short.MAX_VALUE;
    }

    @Override
    public boolean canConvert(Throwable throwable) {
        return throwable instanceof ConstraintViolationException;
    }

    @Override
    public InvocationException convert(Invocation invocation, ConstraintViolationException throwable, Response.StatusType genericStatus) {
        List details = throwable.getConstraintViolations().stream().map(violation -> new ValidateDetail(violation.getPropertyPath().toString(), violation.getMessage())).collect(Collectors.toList());
        CommonExceptionData exceptionData = new CommonExceptionData(this.code.get(), "invalid parameters.");
        exceptionData.putDynamic("validateDetail", details);
        return new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, (Object)exceptionData);
    }
}

