/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import org.apache.servicecomb.core.SCBEngine;

public interface BootListener {
    default public int getOrder() {
        return 0;
    }

    default public void onBootEvent(BootEvent event) {
        switch (event.eventType) {
            case BEFORE_HANDLER: {
                this.onBeforeHandler(event);
                return;
            }
            case AFTER_HANDLER: {
                this.onAfterHandler(event);
                return;
            }
            case BEFORE_FILTER: {
                this.onBeforeFilter(event);
                return;
            }
            case AFTER_FILTER: {
                this.onAfterFilter(event);
                return;
            }
            case BEFORE_PRODUCER_PROVIDER: {
                this.onBeforeProducerProvider(event);
                return;
            }
            case AFTER_PRODUCER_PROVIDER: {
                this.onAfterProducerProvider(event);
                return;
            }
            case BEFORE_CONSUMER_PROVIDER: {
                this.onBeforeConsumerProvider(event);
                return;
            }
            case AFTER_CONSUMER_PROVIDER: {
                this.onAfterConsumerProvider(event);
                return;
            }
            case BEFORE_TRANSPORT: {
                this.onBeforeTransport(event);
                return;
            }
            case AFTER_TRANSPORT: {
                this.onAfterTransport(event);
                return;
            }
            case BEFORE_REGISTRY: {
                this.onBeforeRegistry(event);
                return;
            }
            case AFTER_REGISTRY: {
                this.onAfterRegistry(event);
                return;
            }
            case BEFORE_CLOSE: {
                this.onBeforeClose(event);
                return;
            }
            case AFTER_CLOSE: {
                this.onAfterClose(event);
                return;
            }
        }
        throw new IllegalStateException("unknown boot event type: " + (Object)((Object)event.eventType));
    }

    default public void onBeforeHandler(BootEvent event) {
    }

    default public void onAfterHandler(BootEvent event) {
    }

    default public void onBeforeFilter(BootEvent event) {
    }

    default public void onAfterFilter(BootEvent event) {
    }

    default public void onBeforeProducerProvider(BootEvent event) {
    }

    default public void onAfterProducerProvider(BootEvent event) {
    }

    default public void onBeforeConsumerProvider(BootEvent event) {
    }

    default public void onAfterConsumerProvider(BootEvent event) {
    }

    default public void onBeforeTransport(BootEvent event) {
    }

    default public void onAfterTransport(BootEvent event) {
    }

    default public void onBeforeRegistry(BootEvent event) {
    }

    default public void onAfterRegistry(BootEvent event) {
    }

    default public void onBeforeClose(BootEvent event) {
    }

    default public void onAfterClose(BootEvent event) {
    }

    public static class BootEvent {
        private SCBEngine scbEngine;
        private EventType eventType;

        public SCBEngine getScbEngine() {
            return this.scbEngine;
        }

        public void setScbEngine(SCBEngine scbEngine) {
            this.scbEngine = scbEngine;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public void setEventType(EventType eventType) {
            this.eventType = eventType;
        }
    }

    public static enum EventType {
        BEFORE_HANDLER,
        AFTER_HANDLER,
        BEFORE_FILTER,
        AFTER_FILTER,
        BEFORE_PRODUCER_PROVIDER,
        AFTER_PRODUCER_PROVIDER,
        BEFORE_CONSUMER_PROVIDER,
        AFTER_CONSUMER_PROVIDER,
        BEFORE_TRANSPORT,
        AFTER_TRANSPORT,
        BEFORE_REGISTRY,
        AFTER_REGISTRY,
        BEFORE_CLOSE,
        AFTER_CLOSE;

    }
}

