/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.apache.servicecomb.provider.springmvc.reference.CseClientHttpRequest;
import org.apache.servicecomb.provider.springmvc.reference.CseClientHttpResponse;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.client.MessageBodyClientHttpResponseWrapper;

public class CseHttpMessageConverter
implements GenericHttpMessageConverter<Object> {
    private static final List<MediaType> ALL_MEDIA_TYPE = Arrays.asList(MediaType.ALL);
    private static final Field RESPONSE_FIELD = ReflectionUtils.findField(MessageBodyClientHttpResponseWrapper.class, (String)"response");

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return true;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return true;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return ALL_MEDIA_TYPE;
    }

    public Object read(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.read(inputMessage);
    }

    private Object read(HttpInputMessage inputMessage) {
        MessageBodyClientHttpResponseWrapper respWrapper = (MessageBodyClientHttpResponseWrapper)inputMessage;
        CseClientHttpResponse resp = (CseClientHttpResponse)ReflectionUtils.getField((Field)RESPONSE_FIELD, (Object)respWrapper);
        return resp.getResult();
    }

    public void write(Object o, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.write(o, outputMessage);
    }

    private void write(Object o, HttpOutputMessage outputMessage) {
        CseClientHttpRequest request = (CseClientHttpRequest)outputMessage;
        request.setRequestBody(o);
    }

    public boolean canRead(Type type, @Nullable Class<?> contextClass, @Nullable MediaType mediaType) {
        return true;
    }

    public Object read(Type type, @Nullable Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.read(inputMessage);
    }

    public boolean canWrite(@Nullable Type type, Class<?> clazz, @Nullable MediaType mediaType) {
        return true;
    }

    public void write(Object o, @Nullable Type type, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.write(o, outputMessage);
    }

    static {
        RESPONSE_FIELD.setAccessible(true);
    }
}

