/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.Span;
import brave.Tracer;
import brave.http.HttpTracing;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.Filter;
import org.apache.servicecomb.core.filter.FilterMeta;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.tracing.zipkin.ZipkinConsumerDelegate;
import org.apache.servicecomb.tracing.zipkin.ZipkinProviderDelegate;
import org.apache.servicecomb.tracing.zipkin.ZipkinTracingDelegate;

@FilterMeta(name="zipkin")
public class ZipkinTracingFilter
implements Filter {
    private ZipkinConsumerDelegate consumer;
    private ZipkinProviderDelegate producer;

    public void init(SCBEngine engine) {
        HttpTracing httpTracing = (HttpTracing)BeanUtils.getContext().getBean(HttpTracing.class);
        this.consumer = new ZipkinConsumerDelegate(httpTracing);
        this.producer = new ZipkinProviderDelegate(httpTracing);
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        ZipkinTracingDelegate tracing = this.collectTracing(invocation);
        Span span = tracing.createSpan(invocation);
        try (Tracer.SpanInScope scope = tracing.tracer().tracer().withSpanInScope(span);){
            CompletionStage completionStage = nextNode.onFilter(invocation).whenComplete((response, exception) -> tracing.onResponse(span, (Response)response, Exceptions.unwrap((Throwable)exception)));
            return completionStage;
        }
    }

    private ZipkinTracingDelegate collectTracing(Invocation invocation) {
        if (InvocationType.PRODUCER.equals((Object)invocation.getInvocationType())) {
            return this.producer;
        }
        return this.consumer;
    }
}

