/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client.http;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.servicecomb.service.center.client.http.HttpTransportImpl;
import org.apache.servicecomb.service.center.client.http.TLSConfig;

public class TLSHttpsTransport
extends HttpTransportImpl {
    private static final int DEFAULT_MAX_CONNECTIONS = 1000;
    private static final int DEFAULT_MAX_PER_ROUTE = 500;
    private static final int DEFAULT_REQUEST_TIMEOUT = 5000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;

    public TLSHttpsTransport() {
    }

    public TLSHttpsTransport(TLSConfig tlsConfig) {
        KeyStore keyStore = this.getKeyStore(tlsConfig.getKeyStore(), tlsConfig.getKeyStoreType().name(), tlsConfig.getKeyStoreValue());
        KeyStore trustStore = this.getKeyStore(tlsConfig.getTrustStore(), TLSConfig.KeyStoreInstanceType.JKS.name(), tlsConfig.getTrustStoreValue());
        SSLContext sslContext = this.getSSLContext(keyStore, tlsConfig.getKeyStoreValue(), trustStore);
        assert (sslContext != null);
        Registry connectionSocketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(connectionSocketFactoryRegistry);
        connectionManager.setMaxTotal(1000);
        connectionManager.setDefaultMaxPerRoute(500);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext)).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(config);
        this.httpClient = httpClientBuilder.build();
    }

    private KeyStore getKeyStore(String keyStorePath, String keyStoreType, String keyStoreValue) {
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            FileInputStream inputStream = new FileInputStream(keyStorePath);
            keyStore.load(inputStream, keyStoreValue.toCharArray());
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            e.printStackTrace();
            return null;
        }
    }

    private SSLContext getSSLContext(KeyStore keyStore, String keyStoreValue, KeyStore trustStore) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyStoreValue.toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            e.printStackTrace();
            return null;
        }
    }
}

