/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.loadbalancer.Server;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.cache.CacheEndpoint;

public class ServiceCombServer
extends Server {
    private final Endpoint endpoint;
    private final MicroserviceInstance instance;

    @VisibleForTesting
    ServiceCombServer(Endpoint endpoint, MicroserviceInstance instance) {
        super(null);
        this.endpoint = endpoint;
        this.instance = instance;
        this.setAlive(true);
        this.setReadyToServe(true);
    }

    public ServiceCombServer(Transport transport, CacheEndpoint cacheEndpoint) {
        super(null);
        this.endpoint = new Endpoint(transport, cacheEndpoint.getEndpoint(), cacheEndpoint.getInstance());
        this.instance = cacheEndpoint.getInstance();
        this.setAlive(true);
        this.setReadyToServe(true);
        try {
            URI endpointURI = new URI(this.endpoint.getEndpoint());
            this.setHost(endpointURI.getHost());
            this.setPort(endpointURI.getPort());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public MicroserviceInstance getInstance() {
        return this.instance;
    }

    public String toString() {
        return this.endpoint.getEndpoint();
    }

    public String getHost() {
        return this.endpoint.getEndpoint();
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceCombServer) {
            return this.instance.getInstanceId().equals(((ServiceCombServer)((Object)o)).instance.getInstanceId());
        }
        return false;
    }

    public int hashCode() {
        return this.instance.getInstanceId().hashCode();
    }
}

