/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import org.apache.servicecomb.provider.springmvc.reference.AcceptableRestTemplate;
import org.apache.servicecomb.provider.springmvc.reference.CseClientHttpRequestFactory;
import org.apache.servicecomb.provider.springmvc.reference.CseRequestCallback;
import org.apache.servicecomb.provider.springmvc.reference.CseUriTemplateHandler;
import org.springframework.web.client.CseHttpMessageConverter;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.util.UriTemplateHandler;

public class CseRestTemplate
extends AcceptableRestTemplate {
    public CseRestTemplate() {
        this.setMessageConverters(Arrays.asList(new CseHttpMessageConverter()));
        this.setRequestFactory(new CseClientHttpRequestFactory());
        this.setUriTemplateHandler((UriTemplateHandler)new CseUriTemplateHandler());
    }

    public <T> RequestCallback httpEntityCallback(Object requestBody) {
        RequestCallback callback = super.httpEntityCallback(requestBody);
        CseRequestCallback cseCallback = new CseRequestCallback(requestBody, callback, null);
        return cseCallback;
    }

    public <T> RequestCallback httpEntityCallback(Object requestBody, Type responseType) {
        RequestCallback callback = super.httpEntityCallback(requestBody, responseType);
        CseRequestCallback cseCallback = new CseRequestCallback(requestBody, callback, responseType);
        return cseCallback;
    }

    @Override
    public boolean isAcceptable(String uri) {
        return uri.startsWith("cse://");
    }

    @Override
    public boolean isAcceptable(URI uri) {
        return "cse".equals(uri.getScheme());
    }
}

