/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.markup.builder.internal.confluenceMarkup;

import io.github.swagger2markup.markup.builder.MarkupAdmonition;
import io.github.swagger2markup.markup.builder.MarkupBlockStyle;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.markup.builder.MarkupTableColumn;
import io.github.swagger2markup.markup.builder.internal.AbstractMarkupDocBuilder;
import io.github.swagger2markup.markup.builder.internal.Markup;
import io.github.swagger2markup.markup.builder.internal.confluenceMarkup.ConfluenceMarkup;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class ConfluenceMarkupBuilder
extends AbstractMarkupDocBuilder {
    private static final Pattern TITLE_PATTERN = Pattern.compile("^h([0-9])\\.\\s+(.*)$");
    private static final String TITLE_FORMAT = "h%d. %s";
    private static final Pattern ESCAPE_CELL_PIPE_PATTERN = Pattern.compile("((\\[.*?(?<!\\\\)\\])|(.))");
    private static final Map<MarkupBlockStyle, String> BLOCK_STYLE = new HashMap<MarkupBlockStyle, String>(){
        {
            this.put(MarkupBlockStyle.EXAMPLE, ">ADMONITION_BLOCK");
            this.put(MarkupBlockStyle.LISTING, "code:");
            this.put(MarkupBlockStyle.LITERAL, "noformat");
            this.put(MarkupBlockStyle.PASSTHROUGH, "html");
            this.put(MarkupBlockStyle.SIDEBAR, ">ADMONITION_BLOCK");
        }
    };
    private static final Map<MarkupAdmonition, String> ADMONITION_BLOCK_STYLE = new HashMap<MarkupAdmonition, String>(){
        {
            this.put(null, "panel:");
            this.put(MarkupAdmonition.CAUTION, "note:");
            this.put(MarkupAdmonition.IMPORTANT, "alert:");
            this.put(MarkupAdmonition.NOTE, "info:");
            this.put(MarkupAdmonition.TIP, "tip:");
            this.put(MarkupAdmonition.WARNING, "warning:");
        }
    };

    public ConfluenceMarkupBuilder() {
    }

    public ConfluenceMarkupBuilder(String newLine) {
        super(newLine);
    }

    @Override
    protected MarkupLanguage getMarkupLanguage() {
        return MarkupLanguage.CONFLUENCE_MARKUP;
    }

    @Override
    public MarkupDocBuilder copy(boolean copyBuffer) {
        ConfluenceMarkupBuilder builder = new ConfluenceMarkupBuilder(this.newLine);
        if (copyBuffer) {
            builder.documentBuilder = new StringBuilder(this.documentBuilder);
        }
        return builder.withAnchorPrefix(this.anchorPrefix);
    }

    @Override
    public MarkupDocBuilder documentTitle(String title) {
        Validate.notBlank((CharSequence)title, (String)"title must not be blank", (Object[])new Object[0]);
        this.documentBuilder.append(String.format(TITLE_FORMAT, 1, title));
        this.documentBuilder.append(this.newLine).append(this.newLine);
        return this;
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel(int level, String title) {
        Validate.notBlank((CharSequence)title, (String)"title must not be blank", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)5L, (long)level);
        this.documentBuilder.append(this.newLine);
        this.documentBuilder.append(String.format(TITLE_FORMAT, level + 1, this.replaceNewLinesWithWhiteSpace(title)));
        this.documentBuilder.append(this.newLine);
        return this;
    }

    @Override
    public MarkupDocBuilder sectionTitleWithAnchorLevel(int level, String title, String anchor) {
        Validate.notBlank((CharSequence)title, (String)"title must not be blank", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)5L, (long)level);
        this.documentBuilder.append(this.newLine);
        this.documentBuilder.append(String.format(TITLE_FORMAT, level + 1, this.replaceNewLinesWithWhiteSpace(title)));
        if (StringUtils.isBlank((CharSequence)anchor)) {
            anchor = title;
        }
        this.documentBuilder.append(" ");
        this.anchor(this.replaceNewLinesWithWhiteSpace(anchor));
        this.documentBuilder.append(this.newLine);
        return this;
    }

    @Override
    public MarkupDocBuilder paragraph(String text, boolean hardbreaks) {
        Validate.notBlank((CharSequence)text, (String)"text must not be blank", (Object[])new Object[0]);
        text = text.trim();
        text = hardbreaks ? this.replaceNewLines(text, ConfluenceMarkup.LINE_BREAK + this.newLine) : this.replaceNewLines(text);
        this.documentBuilder.append(text).append(this.newLine).append(this.newLine);
        return this;
    }

    @Override
    public MarkupDocBuilder pageBreak() {
        this.documentBuilder.append(this.newLine).append("<div style='page-break-before:always;'></div>").append(this.newLine);
        return this;
    }

    @Override
    public MarkupDocBuilder block(String text, MarkupBlockStyle style, String title, MarkupAdmonition admonition) {
        String block = BLOCK_STYLE.get((Object)style);
        boolean admonitionBlock = block.equals(">ADMONITION_BLOCK");
        if (admonitionBlock) {
            block = ADMONITION_BLOCK_STYLE.get((Object)admonition);
        }
        boolean supportTitle = false;
        if (block.endsWith(":")) {
            supportTitle = true;
            block = StringUtils.stripEnd((String)block, (String)":");
        }
        String titleString = null;
        if (admonition != null && !admonitionBlock) {
            titleString = StringUtils.capitalize((String)admonition.name().toLowerCase());
        }
        if (title != null) {
            titleString = (titleString == null ? "" : titleString + " | ") + title;
        }
        final String finalBlock = block;
        Markup blockMarkup = new Markup(){

            @Override
            public String toString() {
                return String.format("{%s}", finalBlock);
            }
        };
        if (!supportTitle) {
            if (titleString != null) {
                this.documentBuilder.append(titleString).append(" : ").append(this.newLine);
            }
            this.delimitedBlockText(blockMarkup, text);
        } else {
            final String finalTitleString = titleString;
            this.delimitedBlockText(new Markup(){

                @Override
                public String toString() {
                    if (finalTitleString == null) {
                        return String.format("{%s}", finalBlock);
                    }
                    return String.format("{%s:title=%s}", finalBlock, finalTitleString);
                }
            }, text, blockMarkup);
        }
        return this;
    }

    @Override
    public MarkupDocBuilder listingBlock(String text, final String language) {
        Markup blockMarkup = new Markup(){

            @Override
            public String toString() {
                return String.format("{%s}", "code");
            }
        };
        if (language != null) {
            this.delimitedBlockText(new Markup(){

                @Override
                public String toString() {
                    return String.format("{code:language=%s}", language);
                }
            }, text, blockMarkup);
        } else {
            this.delimitedBlockText(blockMarkup, text);
        }
        return this;
    }

    @Override
    public MarkupDocBuilder literalText(String text) {
        this.boldText(ConfluenceMarkup.LITERAL, text);
        return this;
    }

    @Override
    public MarkupDocBuilder boldText(String text) {
        this.boldText(ConfluenceMarkup.BOLD, text);
        return this;
    }

    @Override
    public MarkupDocBuilder italicText(String text) {
        this.italicText(ConfluenceMarkup.ITALIC, text);
        return this;
    }

    @Override
    public MarkupDocBuilder unorderedList(List<String> list) {
        this.unorderedList(ConfluenceMarkup.LIST_ENTRY, list);
        return this;
    }

    @Override
    public MarkupDocBuilder unorderedListItem(String item) {
        this.unorderedListItem(ConfluenceMarkup.LIST_ENTRY, item);
        return this;
    }

    @Override
    public MarkupDocBuilder tableWithColumnSpecs(List<MarkupTableColumn> columnSpecs, List<List<String>> cells) {
        Validate.notEmpty(cells, (String)"cells must not be null", (Object[])new Object[0]);
        this.documentBuilder.append(this.newLine);
        if (columnSpecs != null && !columnSpecs.isEmpty()) {
            this.documentBuilder.append("||");
            for (MarkupTableColumn column : columnSpecs) {
                this.documentBuilder.append(this.formatCellContent(StringUtils.defaultString((String)column.header))).append("||");
            }
            this.documentBuilder.append(this.newLine);
        }
        for (List<String> row : cells) {
            this.documentBuilder.append(ConfluenceMarkup.TABLE_COLUMN_DELIMITER);
            ListIterator<String> cellIterator = row.listIterator();
            while (cellIterator.hasNext()) {
                int cellIndex = cellIterator.nextIndex();
                if (columnSpecs != null && columnSpecs.size() > cellIndex && columnSpecs.get((int)cellIndex).headerColumn) {
                    this.documentBuilder.append(ConfluenceMarkup.TABLE_COLUMN_DELIMITER);
                }
                this.documentBuilder.append(this.formatCellContent(cellIterator.next())).append(ConfluenceMarkup.TABLE_COLUMN_DELIMITER);
            }
            this.documentBuilder.append(this.newLine);
        }
        this.documentBuilder.append(this.newLine);
        return this;
    }

    private String formatCellContent(String cell) {
        if (StringUtils.isBlank((CharSequence)(cell = this.replaceNewLines(cell.trim(), ConfluenceMarkup.LINE_BREAK.toString())))) {
            return " ";
        }
        return this.escapeCellPipes(cell);
    }

    private String escapeCellPipes(String cell) {
        Matcher m = ESCAPE_CELL_PIPE_PATTERN.matcher(cell);
        StringBuffer res = new StringBuffer();
        while (m.find()) {
            String repl = m.group(1);
            if (repl.equals(ConfluenceMarkup.TABLE_COLUMN_DELIMITER.toString())) {
                repl = "\\" + ConfluenceMarkup.TABLE_COLUMN_DELIMITER.toString();
            }
            m.appendReplacement(res, Matcher.quoteReplacement(repl));
        }
        m.appendTail(res);
        return res.toString();
    }

    private String normalizeAnchor(String anchor) {
        return this.normalizeAnchor(ConfluenceMarkup.SPACE_ESCAPE, anchor);
    }

    @Override
    public MarkupDocBuilder anchor(String anchor, String text) {
        this.documentBuilder.append(ConfluenceMarkup.ANCHOR_START).append(this.normalizeAnchor(anchor)).append(ConfluenceMarkup.ANCHOR_END);
        return this;
    }

    @Override
    public MarkupDocBuilder crossReference(String document, String anchor, String text) {
        this.crossReferenceRaw(document, this.normalizeAnchor(anchor), text);
        return this;
    }

    @Override
    public MarkupDocBuilder crossReferenceRaw(String document, String anchor, String text) {
        this.documentBuilder.append("[");
        if (StringUtils.isNotBlank((CharSequence)text)) {
            this.documentBuilder.append(text).append("|");
        }
        if (StringUtils.isNotBlank((CharSequence)document)) {
            this.documentBuilder.append(document);
        }
        this.documentBuilder.append("#").append(anchor);
        this.documentBuilder.append("]");
        return this;
    }

    @Override
    public MarkupDocBuilder newLine(boolean forceLineBreak) {
        this.newLine(ConfluenceMarkup.LINE_BREAK, forceLineBreak);
        return this;
    }

    @Override
    public MarkupDocBuilder importMarkup(Reader markupText, MarkupLanguage markupLanguage, int levelOffset) {
        this.importMarkupStyle2(TITLE_PATTERN, TITLE_FORMAT, false, markupText, markupLanguage, levelOffset);
        return this;
    }

    @Override
    public String addFileExtension(String fileName) {
        return fileName + MarkupLanguage.CONFLUENCE_MARKUP.getFileNameExtensions().get(0);
    }
}

