/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client.http;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.param.RestClientRequestImpl;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.foundation.common.http.HttpStatus;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.http.ReadStreamPart;
import org.apache.servicecomb.foundation.vertx.http.VertxClientRequestToHttpServletRequest;
import org.apache.servicecomb.foundation.vertx.http.VertxClientResponseToHttpServletResponse;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultHttpSocketMetric;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RestClientInvocation {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClientInvocation.class);
    private static final String[] INTERNAL_HEADERS = new String[]{"x-cse-context", "x-cse-target-microservice"};
    private HttpClientWithContext httpClientWithContext;
    private Invocation invocation;
    private RestOperationMeta restOperationMeta;
    private AsyncResponse asyncResp;
    private List<HttpClientFilter> httpClientFilters;
    private HttpClientRequest clientRequest;
    private HttpClientResponse clientResponse;
    private Handler<Throwable> throwableHandler = e -> this.fail((ConnectionBase)this.clientRequest.connection(), (Throwable)e);

    public RestClientInvocation(HttpClientWithContext httpClientWithContext, List<HttpClientFilter> httpClientFilters) {
        this.httpClientWithContext = httpClientWithContext;
        this.httpClientFilters = httpClientFilters;
    }

    public void invoke(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        this.invocation = invocation;
        this.asyncResp = asyncResp;
        OperationMeta operationMeta = invocation.getOperationMeta();
        this.restOperationMeta = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        String path = this.createRequestPath(this.restOperationMeta);
        IpPort ipPort = (IpPort)invocation.getEndpoint().getAddress();
        this.createRequest(ipPort, path);
        this.clientRequest.putHeader("x-cse-target-microservice", invocation.getMicroserviceName());
        RestClientRequestImpl restClientRequest = new RestClientRequestImpl(this.clientRequest, this.httpClientWithContext.context(), asyncResp, this.throwableHandler);
        invocation.getHandlerContext().put("servicecomb-invocation-hanlder-requestclient", restClientRequest);
        Buffer requestBodyBuffer = restClientRequest.getBodyBuffer();
        VertxClientRequestToHttpServletRequest requestEx = new VertxClientRequestToHttpServletRequest(this.clientRequest, requestBodyBuffer);
        invocation.getInvocationStageTrace().startClientFiltersRequest();
        for (HttpClientFilter filter : this.httpClientFilters) {
            if (!filter.enabled()) continue;
            filter.beforeSendRequest(invocation, (HttpServletRequestEx)requestEx);
        }
        this.clientRequest.exceptionHandler(e -> {
            LOGGER.error(invocation.getMarker(), "Failed to send request, local:{}, remote:{}.", new Object[]{this.getLocalAddress(), ipPort.getSocketAddress(), e});
            this.throwableHandler.handle(e);
        });
        this.clientRequest.connectionHandler(connection -> {
            LOGGER.debug("http connection connected, local:{}, remote:{}.", (Object)connection.localAddress(), (Object)connection.remoteAddress());
            connection.closeHandler(v -> LOGGER.debug("http connection closed, local:{}, remote:{}.", (Object)connection.localAddress(), (Object)connection.remoteAddress()));
            connection.exceptionHandler(e -> LOGGER.info("http connection exception, local:{}, remote:{}.", new Object[]{connection.localAddress(), connection.remoteAddress(), e}));
        });
        invocation.getInvocationStageTrace().startSend();
        this.httpClientWithContext.runOnContext(httpClient -> {
            this.clientRequest.setTimeout(operationMeta.getConfig().getMsRequestTimeout());
            this.processServiceCombHeaders(invocation, operationMeta);
            try {
                restClientRequest.end();
            }
            catch (Throwable e) {
                LOGGER.error(invocation.getMarker(), "send http request failed, local:{}, remote: {}.", new Object[]{this.getLocalAddress(), ipPort, e});
                this.fail((ConnectionBase)this.clientRequest.connection(), e);
            }
        });
    }

    private void processServiceCombHeaders(Invocation invocation, OperationMeta operationMeta) {
        if (invocation.isThirdPartyInvocation() && operationMeta.getConfig().isClientRequestHeaderFilterEnabled()) {
            for (String internalHeaderName : INTERNAL_HEADERS) {
                this.clientRequest.headers().remove(internalHeaderName);
            }
            return;
        }
        this.setCseContext();
    }

    private String getLocalAddress() {
        HttpConnection connection = this.clientRequest.connection();
        if (connection == null) {
            return "not connected";
        }
        SocketAddress socketAddress = connection.localAddress();
        return socketAddress != null ? socketAddress.toString() : "not connected";
    }

    private HttpMethod getMethod() {
        OperationMeta operationMeta = this.invocation.getOperationMeta();
        RestOperationMeta swaggerRestOperation = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        String method = swaggerRestOperation.getHttpMethod();
        return HttpMethod.valueOf((String)method);
    }

    void createRequest(IpPort ipPort, String path) {
        URIEndpointObject endpoint = (URIEndpointObject)this.invocation.getEndpoint().getAddress();
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setHost(ipPort.getHostOrIp()).setPort(ipPort.getPort()).setSsl(Boolean.valueOf(endpoint.isSslEnabled())).setURI(path);
        HttpMethod method = this.getMethod();
        LOGGER.debug(this.invocation.getMarker(), "Sending request by rest, method={}, qualifiedName={}, path={}, endpoint={}.", new Object[]{method, this.invocation.getMicroserviceQualifiedName(), path, this.invocation.getEndpoint().getEndpoint()});
        this.clientRequest = this.httpClientWithContext.getHttpClient().request(method, requestOptions, this::handleResponse);
    }

    protected void handleResponse(HttpClientResponse httpClientResponse) {
        this.clientResponse = httpClientResponse;
        if (HttpStatus.isSuccess((int)this.clientResponse.statusCode()) && this.restOperationMeta.isDownloadFile()) {
            ReadStreamPart part = new ReadStreamPart(this.httpClientWithContext.context(), httpClientResponse);
            this.invocation.getHandlerContext().put("servicecomb-readStreamPart", part);
            this.processResponseBody(null);
            return;
        }
        httpClientResponse.exceptionHandler(e -> {
            LOGGER.error(this.invocation.getMarker(), "Failed to receive response, local:{}, remote:{}.", new Object[]{this.getLocalAddress(), httpClientResponse.netSocket().remoteAddress(), e});
            this.fail((ConnectionBase)this.clientRequest.connection(), (Throwable)e);
        });
        this.clientResponse.bodyHandler(this::processResponseBody);
    }

    protected void processResponseBody(Buffer responseBuf) {
        DefaultHttpSocketMetric httpSocketMetric = (DefaultHttpSocketMetric)((ConnectionBase)this.clientRequest.connection()).metric();
        this.invocation.getInvocationStageTrace().finishGetConnection(httpSocketMetric.getRequestBeginTime());
        this.invocation.getInvocationStageTrace().finishWriteToBuffer(httpSocketMetric.getRequestEndTime());
        this.invocation.getInvocationStageTrace().finishReceiveResponse();
        this.invocation.getResponseExecutor().execute(() -> {
            try {
                this.invocation.getInvocationStageTrace().startClientFiltersResponse();
                VertxClientResponseToHttpServletResponse responseEx = new VertxClientResponseToHttpServletResponse(this.clientResponse, responseBuf);
                for (HttpClientFilter filter : this.httpClientFilters) {
                    Response response;
                    if (!filter.enabled() || (response = filter.afterReceiveResponse(this.invocation, (HttpServletResponseEx)responseEx)) == null) continue;
                    this.complete(response);
                    return;
                }
            }
            catch (Throwable e) {
                this.fail(null, e);
            }
        });
    }

    protected void complete(Response response) {
        this.invocation.getInvocationStageTrace().finishClientFiltersResponse();
        this.asyncResp.complete(response);
    }

    protected void fail(ConnectionBase connection, Throwable e) {
        if (this.invocation.isFinished()) {
            return;
        }
        InvocationStageTrace stageTrace = this.invocation.getInvocationStageTrace();
        if (connection != null) {
            DefaultHttpSocketMetric httpSocketMetric = (DefaultHttpSocketMetric)connection.metric();
            stageTrace.finishGetConnection(httpSocketMetric.getRequestBeginTime());
            stageTrace.finishWriteToBuffer(httpSocketMetric.getRequestEndTime());
        }
        if (stageTrace.getFinishReceiveResponse() == 0L) {
            stageTrace.finishReceiveResponse();
        }
        if (stageTrace.getStartClientFiltersResponse() == 0L) {
            stageTrace.startClientFiltersResponse();
        }
        stageTrace.finishClientFiltersResponse();
        try {
            if (e instanceof TimeoutException) {
                this.asyncResp.consumerFail((Throwable)new InvocationException((Response.StatusType)Response.Status.REQUEST_TIMEOUT, String.format("Request Timeout. Details: %s", e.getMessage())));
                return;
            }
            this.asyncResp.fail(this.invocation.getInvocationType(), e);
        }
        catch (Throwable e1) {
            LOGGER.error(this.invocation.getMarker(), "failed to invoke asyncResp.fail.", e1);
        }
    }

    protected void setCseContext() {
        try {
            String cseContext = JsonUtils.writeValueAsString((Object)this.invocation.getContext());
            this.clientRequest.putHeader("x-cse-context", cseContext);
        }
        catch (Throwable e) {
            LOGGER.debug(this.invocation.getMarker(), "Failed to encode and set cseContext.", e);
        }
    }

    protected String createRequestPath(RestOperationMeta swaggerRestOperation) throws Exception {
        URIEndpointObject address = (URIEndpointObject)this.invocation.getEndpoint().getAddress();
        String urlPrefix = address.getFirst("urlPrefix");
        String path = (String)this.invocation.getHandlerContext().get("rest-client-request-path");
        if (path == null) {
            path = swaggerRestOperation.getPathBuilder().createRequestPath(this.invocation.getSwaggerArguments());
        }
        if (StringUtils.isEmpty((Object)urlPrefix) || path.startsWith(urlPrefix)) {
            return path;
        }
        return urlPrefix + path;
    }
}

