/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.client;

import java.io.StringReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.servicecomb.config.kie.client.KieConfig;
import org.apache.servicecomb.config.kie.model.KVDoc;
import org.apache.servicecomb.config.kie.model.KVResponse;
import org.apache.servicecomb.config.kie.model.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class KieUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieUtil.class);

    public static String encrypt(String dataStr) {
        MessageDigest messageDigest = null;
        String result = "";
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(dataStr.getBytes(StandardCharsets.UTF_8));
            result = new BigInteger(1, messageDigest.digest(dataStr.getBytes(StandardCharsets.UTF_8))).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Failed to generate MD5 . ", (Throwable)e);
        }
        return result;
    }

    public static Map<String, Object> getConfigByLabel(KVResponse resp) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<KVDoc> appList = new ArrayList<KVDoc>();
        ArrayList<KVDoc> serviceList = new ArrayList<KVDoc>();
        ArrayList<KVDoc> versionList = new ArrayList<KVDoc>();
        for (KVDoc kvDoc : resp.getData()) {
            Map<String, String> labelsMap = kvDoc.getLabels();
            if (!labelsMap.containsKey("app") || !labelsMap.get("app").equals(KieConfig.INSTANCE.getAppName()) || !labelsMap.containsKey("env") || !labelsMap.get("env").equals(KieConfig.INSTANCE.getEnvironment())) continue;
            if (!labelsMap.containsKey("service")) {
                appList.add(kvDoc);
            }
            if (!labelsMap.containsKey("service") || !labelsMap.get("service").equals(KieConfig.INSTANCE.getServiceName())) continue;
            if (!kvDoc.getLabels().containsKey("version")) {
                serviceList.add(kvDoc);
            }
            if (!labelsMap.containsKey("version") || !labelsMap.get("version").equals(KieConfig.INSTANCE.getServiceName())) continue;
            versionList.add(kvDoc);
        }
        for (KVDoc kvDoc : appList) {
            resultMap.putAll(KieUtil.processValueType(kvDoc));
        }
        for (KVDoc kvDoc : serviceList) {
            resultMap.putAll(KieUtil.processValueType(kvDoc));
        }
        for (KVDoc kvDoc : versionList) {
            resultMap.putAll(KieUtil.processValueType(kvDoc));
        }
        return resultMap;
    }

    public static Map<String, String> processValueType(KVDoc kvDoc) {
        ValueType vtype;
        try {
            vtype = ValueType.valueOf(kvDoc.getValueType());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("value type not support");
        }
        Properties properties = new Properties();
        Map<String, String> kvMap = new HashMap<String, String>();
        try {
            if (vtype == ValueType.YMAL || vtype == ValueType.YML) {
                YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
                yamlFactory.setResources(new Resource[]{new ByteArrayResource(kvDoc.getValue().getBytes())});
                properties = yamlFactory.getObject();
            } else if (vtype == ValueType.PROPERTIES) {
                properties.load(new StringReader(kvDoc.getValue()));
            } else {
                if (vtype == ValueType.TEXT || vtype == ValueType.STRING) {
                    kvMap.put(kvDoc.getKey(), kvDoc.getValue());
                    return kvMap;
                }
                kvMap.put(kvDoc.getKey(), kvDoc.getValue());
                return kvMap;
            }
            kvMap = KieUtil.toMap(kvDoc.getKey(), properties);
            return kvMap;
        }
        catch (Exception e) {
            LOGGER.error("read config failed");
            return Collections.emptyMap();
        }
    }

    private static Map<String, String> toMap(String prefix, Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String value;
            String key = (String)keys.nextElement();
            if (!StringUtils.isEmpty((Object)prefix)) {
                key = prefix + "." + key;
            }
            if ((value = properties.getProperty(key)) != null) {
                result.put(key, value.trim());
                continue;
            }
            result.put(key, null);
        }
        return result;
    }
}

