/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.registry;

import com.google.common.eventbus.EventBus;
import org.apache.servicecomb.config.archaius.sources.MicroserviceConfigLoader;
import org.apache.servicecomb.foundation.common.event.SimpleEventBus;
import org.apache.servicecomb.serviceregistry.ServiceRegistry;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.definition.MicroserviceDefinition;
import org.apache.servicecomb.serviceregistry.registry.LocalServiceRegistry;
import org.apache.servicecomb.serviceregistry.registry.RemoteServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class ServiceRegistryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryFactory.class);
    private static final Object LOCK = new Object();
    private static volatile ServiceRegistry serviceRegistry;

    private ServiceRegistryFactory() {
    }

    public static ServiceRegistry getServiceRegistry() {
        return serviceRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceRegistry getOrCreate(EventBus eventBus, ServiceRegistryConfig serviceRegistryConfig, MicroserviceDefinition microserviceDefinition) {
        if (serviceRegistry == null) {
            Object object = LOCK;
            synchronized (object) {
                if (serviceRegistry == null) {
                    serviceRegistry = ServiceRegistryFactory.create(eventBus, serviceRegistryConfig, microserviceDefinition);
                }
            }
        }
        return serviceRegistry;
    }

    public static ServiceRegistry createLocal() {
        return ServiceRegistryFactory.createLocal(System.getProperty("local.registry.file"));
    }

    public static ServiceRegistry createLocal(String localFile) {
        SimpleEventBus eventBus = new SimpleEventBus();
        ServiceRegistryConfig serviceRegistryConfig = ServiceRegistryConfig.INSTANCE;
        MicroserviceConfigLoader loader = new MicroserviceConfigLoader();
        loader.loadAndSort();
        MicroserviceDefinition microserviceDefinition = new MicroserviceDefinition(loader.getConfigModels());
        return new LocalServiceRegistry((EventBus)eventBus, serviceRegistryConfig, microserviceDefinition).localFile(localFile);
    }

    public static ServiceRegistry create(EventBus eventBus, ServiceRegistryConfig serviceRegistryConfig, MicroserviceDefinition microserviceDefinition) {
        String localModeFile = System.getProperty("local.registry.file");
        if (!StringUtils.isEmpty((Object)localModeFile)) {
            LOGGER.info("It is running in the local development mode, the local file {} is using as the local registry", (Object)localModeFile);
            return new LocalServiceRegistry(eventBus, serviceRegistryConfig, microserviceDefinition);
        }
        LOGGER.info("It is running in the normal mode, a separated service registry is required");
        return new RemoteServiceRegistry(eventBus, serviceRegistryConfig, microserviceDefinition);
    }
}

