/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import java.time.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.servicecomb.foundation.common.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCombServerStats {
    private static final long TIME_WINDOW_IN_MILLISECONDS = 60000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombServerStats.class);
    private static AtomicBoolean globalAllowIsolatedServerTryingFlag = new AtomicBoolean(true);
    private final Object lock = new Object();
    Clock clock;
    private long lastWindow;
    private AtomicLong continuousFailureCount;
    private long lastVisitTime;
    private long lastActiveTime;
    private AtomicLong totalRequests;
    private AtomicLong successRequests;
    private AtomicLong failedRequests;
    private boolean isolated = false;

    public ServiceCombServerStats() {
        this.clock = TimeUtils.getSystemDefaultZoneClock();
        this.init();
    }

    public ServiceCombServerStats(Clock clock) {
        this.clock = clock;
        this.init();
    }

    private void init() {
        this.lastWindow = this.clock.millis();
        this.continuousFailureCount = new AtomicLong(0L);
        this.lastVisitTime = this.clock.millis();
        this.lastActiveTime = this.clock.millis();
        this.totalRequests = new AtomicLong(0L);
        this.successRequests = new AtomicLong(0L);
        this.failedRequests = new AtomicLong(0L);
    }

    public static boolean isolatedServerCanTry() {
        return globalAllowIsolatedServerTryingFlag.get();
    }

    public static boolean applyForTryingChance() {
        return ServiceCombServerStats.isolatedServerCanTry() && globalAllowIsolatedServerTryingFlag.compareAndSet(true, false);
    }

    public static void releaseTryingChance() {
        globalAllowIsolatedServerTryingFlag.set(true);
    }

    public void markIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public void markSuccess() {
        long time = this.clock.millis();
        this.ensureWindow(time);
        this.lastVisitTime = time;
        this.lastActiveTime = time;
        this.totalRequests.incrementAndGet();
        this.successRequests.incrementAndGet();
        this.continuousFailureCount.set(0L);
        if (this.isolated) {
            LOGGER.info("trying server invocation success!");
        }
    }

    public void markFailure() {
        long time = this.clock.millis();
        this.ensureWindow(time);
        this.lastVisitTime = time;
        if (!this.isolated) {
            this.totalRequests.incrementAndGet();
            this.failedRequests.incrementAndGet();
            this.continuousFailureCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWindow(long time) {
        if (time - this.lastWindow > 60000L) {
            Object object = this.lock;
            synchronized (object) {
                if (time - this.lastWindow > 60000L) {
                    if (!this.isolated) {
                        this.continuousFailureCount.set(0L);
                        this.totalRequests.set(0L);
                        this.successRequests.set(0L);
                        this.failedRequests.set(0L);
                    }
                    this.lastWindow = time;
                }
            }
        }
    }

    public long getLastVisitTime() {
        return this.lastVisitTime;
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public long getCountinuousFailureCount() {
        return this.continuousFailureCount.get();
    }

    public long getTotalRequests() {
        return this.totalRequests.get();
    }

    public long getSuccessRequests() {
        return this.successRequests.get();
    }

    public long getFailedRequests() {
        return this.failedRequests.get();
    }

    public int getSuccessRate() {
        return this.calcRequestRate(this.successRequests);
    }

    public int getFailedRate() {
        return this.calcRequestRate(this.failedRequests);
    }

    private int calcRequestRate(AtomicLong requestCnt) {
        long totalReqs = this.totalRequests.get();
        if (totalReqs == 0L) {
            return 0;
        }
        return (int)(requestCnt.get() * 100L / totalReqs);
    }

    public boolean isIsolated() {
        return this.isolated;
    }
}

