/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.annotation;

import io.swagger.annotations.Extension;
import io.swagger.annotations.License;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.util.BaseReaderUtils;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.ClassAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;

public class SwaggerDefinitionProcessor
implements ClassAnnotationProcessor<SwaggerDefinition> {
    @Override
    public Type getProcessType() {
        return SwaggerDefinition.class;
    }

    @Override
    public void process(SwaggerGenerator swaggerGenerator, SwaggerDefinition definitionAnnotation) {
        Swagger swagger = swaggerGenerator.getSwagger();
        if (StringUtils.isNotEmpty((CharSequence)definitionAnnotation.basePath())) {
            swaggerGenerator.setBasePath(definitionAnnotation.basePath());
        }
        if (StringUtils.isNotEmpty((CharSequence)definitionAnnotation.host())) {
            swagger.setHost(definitionAnnotation.host());
        }
        SwaggerUtils.setConsumes(swagger, definitionAnnotation.consumes());
        SwaggerUtils.setProduces(swagger, definitionAnnotation.produces());
        this.convertSchemes(definitionAnnotation, swagger);
        this.convertTags(definitionAnnotation, swagger);
        this.convertInfo(definitionAnnotation.info(), swagger);
        swagger.setExternalDocs(this.convertExternalDocs(definitionAnnotation.externalDocs()));
    }

    private void convertInfo(io.swagger.annotations.Info infoAnnotation, Swagger swagger) {
        if (infoAnnotation == null) {
            return;
        }
        Info info = new Info();
        info.setTitle(infoAnnotation.title());
        info.setVersion(infoAnnotation.version());
        if (StringUtils.isNotEmpty((CharSequence)infoAnnotation.description())) {
            info.setDescription(infoAnnotation.description());
        }
        if (StringUtils.isNotEmpty((CharSequence)infoAnnotation.termsOfService())) {
            info.setTermsOfService(infoAnnotation.termsOfService());
        }
        info.setContact(this.convertContact(infoAnnotation.contact()));
        info.setLicense(this.convertLicense(infoAnnotation.license()));
        info.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])infoAnnotation.extensions()));
        swagger.setInfo(info);
    }

    private io.swagger.models.License convertLicense(License licenseAnnotation) {
        io.swagger.models.License license = new io.swagger.models.License();
        if (StringUtils.isNotEmpty((CharSequence)licenseAnnotation.name())) {
            license.setName(licenseAnnotation.name());
        }
        if (StringUtils.isNotEmpty((CharSequence)licenseAnnotation.url())) {
            license.setUrl(licenseAnnotation.url());
        }
        if (StringUtils.isEmpty((CharSequence)license.getName()) && StringUtils.isEmpty((CharSequence)license.getUrl())) {
            return null;
        }
        return license;
    }

    private Contact convertContact(io.swagger.annotations.Contact contactAnnotation) {
        Contact contact = new Contact();
        if (StringUtils.isNotEmpty((CharSequence)contactAnnotation.name())) {
            contact.setName(contactAnnotation.name());
        }
        if (StringUtils.isNotEmpty((CharSequence)contactAnnotation.url())) {
            contact.setUrl(contactAnnotation.url());
        }
        if (StringUtils.isNotEmpty((CharSequence)contactAnnotation.email())) {
            contact.setEmail(contactAnnotation.email());
        }
        if (StringUtils.isEmpty((CharSequence)contact.getName()) && StringUtils.isEmpty((CharSequence)contact.getUrl()) && StringUtils.isEmpty((CharSequence)contact.getEmail())) {
            return null;
        }
        return contact;
    }

    private void convertTags(SwaggerDefinition definitionAnnotation, Swagger swagger) {
        if (definitionAnnotation.tags() == null) {
            return;
        }
        Stream stream = Arrays.asList(definitionAnnotation.tags()).stream();
        List tags = stream.filter(t -> !t.name().isEmpty()).map(this::convertTag).collect(Collectors.toList());
        if (tags.isEmpty()) {
            return;
        }
        swagger.setTags(tags);
    }

    private Tag convertTag(io.swagger.annotations.Tag tagAnnotation) {
        Tag tag = new Tag();
        tag.setName(tagAnnotation.name());
        tag.setDescription(tagAnnotation.description());
        tag.setExternalDocs(this.convertExternalDocs(tagAnnotation.externalDocs()));
        tag.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])tagAnnotation.extensions()));
        return tag;
    }

    private ExternalDocs convertExternalDocs(io.swagger.annotations.ExternalDocs annotationExternalDocs) {
        ExternalDocs externalDocs = new ExternalDocs();
        if (StringUtils.isNotEmpty((CharSequence)annotationExternalDocs.url())) {
            externalDocs.setUrl(annotationExternalDocs.url());
        }
        if (StringUtils.isNotEmpty((CharSequence)annotationExternalDocs.value())) {
            externalDocs.setDescription(annotationExternalDocs.value());
        }
        if (StringUtils.isEmpty((CharSequence)externalDocs.getUrl()) && StringUtils.isEmpty((CharSequence)externalDocs.getDescription())) {
            return null;
        }
        return externalDocs;
    }

    private void convertSchemes(SwaggerDefinition definitionAnnotation, Swagger swagger) {
        if (definitionAnnotation.schemes() == null) {
            return;
        }
        Stream stream = Arrays.asList(definitionAnnotation.schemes()).stream();
        List schemes = stream.map(this::convertScheme).collect(Collectors.toList());
        swagger.setSchemes(schemes);
    }

    private Scheme convertScheme(SwaggerDefinition.Scheme annotationScheme) {
        if (SwaggerDefinition.Scheme.DEFAULT.equals((Object)annotationScheme)) {
            return Scheme.HTTP;
        }
        return Scheme.forValue((String)annotationScheme.name());
    }
}

