/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorUtils;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;

public class ParameterGenerator {
    private String parameterName;
    private List<Annotation> annotations;
    private Type genericType;
    private HttpParameterType httpParameterType;
    private io.swagger.models.parameters.Parameter generatedParameter;

    public ParameterGenerator(String parameterName, List<Annotation> annotations, Type genericType, HttpParameterType httpParameterType, io.swagger.models.parameters.Parameter generatedParameter) {
        this.parameterName = parameterName;
        this.annotations = annotations;
        this.genericType = genericType;
        this.httpParameterType = httpParameterType;
        this.generatedParameter = generatedParameter;
    }

    public ParameterGenerator(Executable executable, Map<String, List<Annotation>> methodAnnotationMap, String defaultName, Annotation[] parameterAnnotations, Type genericType) {
        this.parameterName = SwaggerGeneratorUtils.collectParameterName(executable, parameterAnnotations, defaultName);
        this.annotations = SwaggerGeneratorUtils.collectParameterAnnotations(parameterAnnotations, methodAnnotationMap, this.parameterName);
        this.genericType = SwaggerGeneratorUtils.collectGenericType(this.annotations, genericType);
        this.httpParameterType = SwaggerGeneratorUtils.collectHttpParameterType(this.annotations, genericType);
    }

    public ParameterGenerator(Executable executable, Map<String, List<Annotation>> methodAnnotationMap, Parameter methodParameter, Type genericType) {
        this(executable, methodAnnotationMap, methodParameter.isNamePresent() ? methodParameter.getName() : null, methodParameter.getAnnotations(), genericType);
    }

    public ParameterGenerator(String parameterName, List<Annotation> annotations) {
        this.parameterName = parameterName;
        this.annotations = annotations;
        this.genericType = SwaggerGeneratorUtils.collectGenericType(annotations, null);
        this.httpParameterType = SwaggerGeneratorUtils.collectHttpParameterType(annotations, this.genericType);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public HttpParameterType getHttpParameterType() {
        return this.httpParameterType;
    }

    public void setHttpParameterType(HttpParameterType httpParameterType) {
        this.httpParameterType = httpParameterType;
    }

    public io.swagger.models.parameters.Parameter getGeneratedParameter() {
        return this.generatedParameter;
    }

    public void setGeneratedParameter(io.swagger.models.parameters.Parameter generatedParameter) {
        this.generatedParameter = generatedParameter;
    }
}

