/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.invocation;

import java.util.Map;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.serviceregistry.RegistryUtils;

public final class InvocationFactory {
    private InvocationFactory() {
    }

    private static String getMicroserviceName() {
        return RegistryUtils.getMicroservice().getServiceName();
    }

    public static Invocation forConsumer(ReferenceConfig referenceConfig, OperationMeta operationMeta, Map<String, Object> swaggerArguments) {
        Invocation invocation = new Invocation(referenceConfig, operationMeta, swaggerArguments);
        invocation.addContext("x-cse-src-microservice", InvocationFactory.getMicroserviceName());
        return invocation;
    }

    public static Invocation forConsumer(ReferenceConfig referenceConfig, SchemaMeta schemaMeta, String operationId, Map<String, Object> swaggerArguments) {
        OperationMeta operationMeta = schemaMeta.ensureFindOperation(operationId);
        return InvocationFactory.forConsumer(referenceConfig, operationMeta, swaggerArguments);
    }

    public static Invocation forProvider(Endpoint endpoint, OperationMeta operationMeta, Map<String, Object> swaggerArguments) {
        SCBEngine.getInstance().ensureStatusUp();
        return new Invocation(endpoint, operationMeta, swaggerArguments);
    }
}

